#!/bin/sh
#
# Build contrib packages (gsl and poco libraries)
# NOTE: You must download the sources before - call download_contrib.sh if they aren't
# downloaded.
# USAGE:
# install_contrib.sh <installation directory> [SHARED], where you set SHARED to ON if you
# want shared libs.
#
usage () {
  echo "install_contrib.sh PREFIX [SHARED]"
}

# fix prefix - we need an absolute path for gsl
# NOTE: If no prefix given, default to odemxdir/install
if [[ "" == $1 ]];
then
	echo "No installation directory given. Aborting."
	echo "Note: if you don't want to edit the defaults given by cmake, use
	install_contrib.sh yourodemxdirectory/install"
	usage
	exit -1
else
	PREFIX=$1
fi
cd $PREFIX || exit 1
PREFIX=`pwd`
cd -

SHARED=$2
WITH_ODBC=$3

if [ "" = "$PREFIX" ];
then
  usage
  echo "No prefix given. Abort."
  exit 1
fi

#########
# Build POCO
#########

cd poco

if [ "$WITH_ODBC" = "ON" ]
then
  ./configure --prefix=$PREFIX --no-tests --no-samples --omit=Data/MySQL,Crypt,NetSSL_OpenSSL
else
  ./configure --prefix=$PREFIX --no-tests --no-samples --omit=Data/MySQL,Crypt,NetSSL_OpenSSL,Data/ODBC
fi

if [ "$SHARED" = "ON" ]
then
 LNKMODE=SHARED 
else
 LNKMODE=STATIC 
fi
make LINKMODE=${LNKMODE}
make install

cd -


##################
# build gsl
##################
GSL_DIR="gsl-1.13"

if [ -d $GSL_DIR ]; then
		cd $GSL_DIR
		if [ "$SHARED" = "ON" ]
		then
				./configure --prefix=$PREFIX
		else
				./configure --prefix=$PREFIX --disable-shared
		fi
		make
		make install

		cd -
else
		echo "Error: Couldn't find $GSL_DIR. Did you download gsl using download_contrib.sh?"
fi

################
# UnitTest++
################
cd UnitTest++
make
make install
cd -

