#ifndef ODEMX_HTML_GENERATOR_INCLUDED
#define ODEMX_HTML_GENERATOR_INCLUDED

#include <iostream>
#include <ostream>
#include <fstream>
#include <string>
#include <odemx/base/Simulation.h>

namespace odemx {

	class HtmlGenerator {
	protected:
		
		HtmlGenerator( Simulation* sim );
		
		/// produce HTML output from xml files
		void generateHtml( std::string xmlFileName, std::string traceFilter );
		
		// Implementation
	private:

		/**
			\name Html generation help functions

			Generation of an html file belonging to a trace is
			done in several steps, involving header construction,
			script and menu generation, and the html file's
			content body.  

			@{
		*/
		void htmlHead( std::string xmlFileName ); ///< build head with style, script
		void htmlBodyCaption( std::string filter ); ///< build page caption
		void htmlBodyNavigation(); ///< build page navigation
		void htmlBodyFoot(); ///< build page content and close
		//@}

	private:
		Simulation* env;
		std::ostream* htmlStream; ///< outstream for HTML text
	};


}




#endif /* ODEMX_HTML_GENERATOR_INCLUDED */
