//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file ErrorHandling.cpp

	\author Ralf Gerstenberger
	<!-- [\author <author>]* -->

	\date created at 2002/01/23

	\brief Implementation of functions in ErrorHandling.h

	\sa ErrorHandling.h

	<!-- [detailed description] -->

	<!-- [\todo {todos for this file}]* -->

	\since 1.0
*/

#if defined(_MSC_VER) && defined(FORCE_STACK_IMPL)
#pragma warning(disable : 4530)
#endif

#include <odemx/util/ErrorHandling.h>
#include <iostream>

namespace odemx {
	// debug() writes the message to stderr and continues;
	void debug(const char* message) {
#ifdef _DEBUG
		std::cerr << "ODEMx DEBUG: " << message << std::endl;
#endif
	}

	// warning() writes the message to stderr and continues;
	void warning(const char* message) {
		std::cerr << "ODEMx WARNING: " << message << std::endl;
	}

	// error() writes the message to stderr and continues;
	void error(const char* message) {
		std::cerr << "ODEMx ERROR: " << message << std::endl;
	}

	// fatalError writes the message to stderr and terminates the program;
	void fatalError(const char* message, int exitValue) {
		std::cerr << "ODEMx FATAL ERROR: " << message << std::endl; exit(exitValue);
	}
}

