//----------------------------------------------------------------------------
//	Copyright (C) 2002, 2003, 2004 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//----------------------------------------------------------------------------
/**	\file Version.cpp

	\author Ralf Gerstenberger
	<!-- [\author <author>]* -->

	\date created at 2003/06/10

	\brief Implementation of classes in Version.h

	\sa Version.h

	<!-- [detailed description] -->

	<!-- [\todo {todos for this file}]* -->

	\since 1.0
*/

#include <odemx/util/Version.h>

#include <sstream>
#include <string>

using namespace std;
using namespace odemx;

const unsigned int ODEMX_VMAJOR=2;
const unsigned int ODEMX_VMINOR=0;

unsigned int Version::getMajor() {return ODEMX_VMAJOR;}
unsigned int Version::getMinor() {return ODEMX_VMINOR;}
const char* Version::getString() {
	static string vrs="";

	if (vrs.empty()) {
		ostringstream ostr;
		ostr << getMajor() << '.' << getMinor() << ends;
		vrs = ostr.str();
	}

	return vrs.c_str();
}

