debugLib : Debug/libOdemXD.a

include buildTools.make includePath.make
include util.make coroutine.make base.make synchronization.make random.make statistics.make
include protocol.make

CFLAGS=-g -Wall

Debug/%.o : %.cpp
	@echo Compile $< to target $@
	@$(CC) -c $(CFLAGS) -I$(INCLUDEPATH) $< -o $@ 2>>error.log || cat error.log

Debug/libOdemXD.a : $(patsubst %.o,Debug/%.o,$(OBJECTS))
	@if test -f error.log -a ! -s error.log; then rm error.log; fi
	@if test -f error.log;\
	then echo; echo There where errors during build process:; echo;\
	cat error.log;\
	echo; echo see error.log for detail; echo;\
	else echo Building archive; ar rs $@ Debug/*.o;\
	fi

