/*
 *
 *
 *  Created on: 27.05.2010
 *      Author: ingmar
 */
#include "Poco/File.h"
#include "Poco/Path.h"
#include "Poco/Util/IniFileConfiguration.h"
#include "Poco/Util/Application.h"
#include "Poco/Util/Option.h"
#include "Poco/Util/OptionSet.h"
#include "Poco/Util/HelpFormatter.h"
#include "Poco/Util/AbstractConfiguration.h"
#include <iostream>
#include <fstream>

#include "InputFileParser.h"
#include "Walzfolge.h"

using Poco::Util::Application;
using Poco::Util::Option;
using Poco::Util::OptionSet;
using Poco::Util::HelpFormatter;
using Poco::Util::AbstractConfiguration;
using Poco::Util::OptionCallback;
using Poco::File;
using Poco::Path;


class RollingMillApp: public Application {
public:
	RollingMillApp(): _helpRequested(false) {
	}

private:
	bool _helpRequested;
	File* configFile;
	File* inputFile;

protected:

	void abortWithError(int returnValue, std::string message) {
		std::cerr << message << std::endl;
		exit(returnValue);
	}

	void defineOptions(OptionSet& options) {
		Application::defineOptions(options);

		options.addOption(
				Option("help", "h", "display help information on command line arguments")
				.required(false)
				.repeatable(false)
				.callback(OptionCallback<RollingMillApp>(this, &RollingMillApp::handleHelp)));

		options.addOption(
				Option("config", "c", "path to configuration file")
				.required(true)
				.repeatable(false)
				.argument("file")
				.callback(OptionCallback<RollingMillApp>(this, &RollingMillApp::handleConfig)));

		options.addOption(
				Option("input", "i", "path to input file")
				.required(true)
				.repeatable(false)
				.argument("file")
				.callback(OptionCallback<RollingMillApp>(this, &RollingMillApp::handleInput)));

	}

	void handleInput(const std::string& name, const std::string& value) {

		inputFile = new File(value);
		if (!inputFile->exists())
			abortWithError(-1, "input file not found");
	}

	void handleConfig(const std::string& name, const std::string& value) {
		configFile = new File(value);
		if (!configFile->exists())
			abortWithError(-1, "config file not found");
		loadConfiguration(value);
	}

	void handleHelp(const std::string& name, const std::string& value) {
		_helpRequested = true;
		displayHelp();
		stopOptionsProcessing();
	}

	void displayHelp()
	{
		HelpFormatter helpFormatter(options());
		helpFormatter.setCommand(commandName());
		helpFormatter.setUsage("-i=INPUTFILE -c=CONFIGFILE");
		helpFormatter.setHeader("RollingMill-Simulator");
		helpFormatter.format(std::cout);
	}

	virtual int main(const std::vector < std::string > & args) {
		if (_helpRequested) return 0;

		InputFileParser ip(inputFile);
		Walzfolge* walzfolge = ip.getWalzfolge();
		std::cout << "Anzahl Auftraege: " << walzfolge->auftraege.size() << std::endl;

		std::cout << config().getInt("ALLGEMEIN.testValue") << std::endl;
		return 0;
	}
};

POCO_APP_MAIN(RollingMillApp)
