/*
 * InputFileParser.h
 *
 *  Created on: 31.05.2010
 *      Author: ingmar
 */

#ifndef INPUTFILEPARSER_H_
#define INPUTFILEPARSER_H_

#include "Poco/File.h"
#include <list>
#include <map>
#include <string>
#include "Sortiment.h"
#include "Auftrag.h"
#include "Walzfolge.h"

using Poco::File;

class Auftrag;

class InputFileParser {

private:
	std::map<std::string, int> indexMap;
	File* inputFile;
	Walzfolge* walzfolge;
public:
	InputFileParser(File* inputFile);
	~InputFileParser();

	Walzfolge* getWalzfolge();

	Sortiment ermittleSortiment(std::string sortimentName);
};

#endif /* INPUTFILEPARSER_H_ */
