/*
 *
 *
 *  Created on: 27.05.2010
 *      Author: ingmar
 */
#include <iostream>
#include <fstream>
#include <odemx/odemx.h>

using namespace odemx::base;

class Simple: public Continuous {
private:


	virtual void derivatives (double t) {
		rate[0] = 2*state[0];
	}

public:

	// Konstruktor ("1" steht fuer eine Variable)
	Simple( Simulation &sim ): Continuous( sim, "Simple", 1 ) {}

	virtual int main() {

		// Anfangswerte
		state[0] = 1;

		// Schrittweitengrenzen: Min, Max
		setStepLength(0.001, 0.005);

		// Fehlerschranke, Ueberschreitung fuehrt zur
		// Wiederholung des Schritts mit kleinerer Schrittweite
		setErrorlimit(1, 0.01);

		// Start der Integration
		integrate(0, (Condition)&Simple::myCondition);
		std::cout << state[0] << std::endl;
		return 0;
	}

	bool myCondition() {
		return state[0] > 50;
	}

};


int main(int argc, char* argv[]) {

	Simulation &sim = odemx::getDefaultSimulation();

	Simple* mySimple = new Simple( sim );
  
  ContuTrace trace (mySimple);

	mySimple -> activate();


	sim.runUntil(7);

	return 0;
}
