// Example 1 - integer test 
// see www.solarianprogrammer.com "C++11 regex tutorial" for more informations
#include <iostream>
#include <regex>
#include <string>

using namespace std;

static const regex rgxMobile("(01[567][[:digit:]]{6,10})");

// static const regex rgxMobile("(01[567][[:digit:]]{6,10})", regex_constants::Syntax);
/*
 * Syntax includes ECMAScript, basic; extended, awk, grep and egrep
 *
 * icase    - ignore case
 * nosubs   - don't save substrings
 * optimze  - prefer speed (preprocessing, might be useful for often called exprs)
 * collate  - consider language for e.g. [a-z]
 *
 */

bool isMobilephone(const string& text) {
	return regex_match(text, rgxMobile);
}

bool containsMobilephone(const string &text) {
	return regex_search(text, rgxMobile);
}

void listMobilephones(const string& text) {
	sregex_iterator begin( text.cbegin(), text.cend(), rgxMobile );
	sregex_iterator end;
	for(auto it = begin; it != end; it++) {
		cout << it-> str() << " ";
	}
}

void replace() {

	string text = "Titel;Album;Interpret";
	regex muster(";");
	string neu = regex_replace(text, muster, string(","));

}

int main()
{
	string textinput;
	string mobileinput;
	textinput = "xyz01709999 abc 01611887766 uvw";
	mobileinput = "017812345";

	cout << "input is " << textinput << endl;
	cout << "isMobilePhone "<< isMobilephone(textinput) << endl;
	
	cout << "input is " << mobileinput << endl;
	cout << "isMobilePhone " << isMobilephone(mobileinput) << endl;
	
	cout << "input is " << textinput << endl;
	cout << "containsMobilephone " << containsMobilephone(textinput) << endl;
	
	cout << "listMobilephones " << endl;	
	listMobilephones(textinput);
}
