#include <iostream>
#include <ratio>

using namespace std;

template<typename Scale>

struct Length {
	long long val_;
	Length(long long val) : val_(val) {}
	Length() = default;
	Length(const Length&) = default;
	Length& operator=(const Length&) = default;

	//converting
	template<typename Scale2>
	Length(const Length<Scale2> & other) 
	: val_( other.val_*(Scale2::num*Scale::den)/(Scale2::den*Scale::num) ) {}

	long long value() const { return val_; }
};
typedef Length<ratio<1> > m; // or using m = Length<ratio<1>>
typedef Length<kilo> km;
typedef Length<milli> mm;

int main() {
	mm len_km = 300;
	km len_mm = len_km;
	cout << " millimeter:" << len_mm.value() << endl;
}
