/* Example
 * This example measures the execution time of a function
 * it is found on http://en.cppreference.com/w/cpp/chrono/duration/duration_cast
 */
 
#include <iostream>
#include <chrono>
#include <thread>
 
void f()
{
    // std::this_thread::sleep_for(std::chrono::seconds(1));
    std::this_thread::sleep_for(std::chrono::milliseconds(200));
}
 
int main()
{
    auto t1 = std::chrono::high_resolution_clock::now();
    f();
    auto t2 = std::chrono::high_resolution_clock::now();
    std::cout << "f() took "
              << std::chrono::duration_cast<std::chrono::milliseconds>(t2-t1).count()
              << " milliseconds\n";
						// 	<< std::chrono::duration_cast<std::chrono::nanoseconds>(t2-t1).count()
            //  << " nanoseconds\n";

}
