% Based on: http://mathworks.com/company/newsletters/articles/best-practices-for-a-matlab-to-c-workflow-using-real-time-workshop.html
function y = euclidean(x,cb)
%@ typeparameters: n, m
%@ types: x: matrix(double,n,1), y: matrix(double,n,1), cb:matrix(double,n,m)
%@ ensures: \forall j: int32 . (1 <= j && j <= size(cb,2) ==> norm(x-y) <= norm(x-cb(:,j)))
%@ ensures: 0 <= norm(x-y)
%@ ensures: \exists j: int32 . (1 <= j && j <= size(cb,2) && all(y == cb(:,j)))
  idx = int32(1);
  distance = norm(x-cb(:,1));
  index = int32(2);
  while (index <= size(cb,2))
  %@ invariant: \forall j: int32 . (1 <= j && j <= index-1 ==> distance <= norm(x-cb(:,j)))
  %@ invariant: distance == norm(x-cb(:,idx))
  %@ invariant: idx <= index-1 
  	d = norm(x-cb(:,index));
  	if (d < distance)
	  distance = d;
	  idx = index;
  	end
  	index = index+1;
  end
  y = cb(:,idx);
end

function y = norm(p)
%@ typeparameters: n
%@ types: p: matrix(double,n,1), y: double
%@ ensures: y == sqrt(sum(p.*p))
  y = sqrt(sum(p.*p));
end