% 
% Copyright (c) 2016, Yarpiz (www.yarpiz.com)
% All rights reserved. Please read the "license.txt" for license terms.
% 
% Project Code: YPEA126
% Project Title: Non-dominated Sorting Genetic Algorithm III (NSGA-III)
% Publisher: Yarpiz (www.yarpiz.com)
% 
% Implemented by: S. Mostapha Kalami Heris, PhD (member of Yarpiz Team)
% 
% Contact Info: sm.kalami@gmail.com, info@yarpiz.com
% 
% Base Reference Paper:
% K. Deb and H. Jain, "An Evolutionary Many-Objective Optimization Algorithm 
% Using Reference-Point-Based Nondominated Sorting Approach, Part I: Solving
% Problems With Box Constraints,"
% in IEEE Transactions on Evolutionary Computation,
% vol. 18, no. 4, pp. 577-601, Aug. 2014.
% 
% Reference Papaer URL: http://doi.org/10.1109/TEVC.2013.2281535
% 

function [y1 y2]=Crossover(x1,x2,xoverprob)

    %alpha=rand(size(x1));
    if rand<=xoverprob
        testSuiteSize = size(x1,2);
        xoverPoint = randi(testSuiteSize);
        %y1=x1;%alpha.*x1+(1-alpha).*x2;
        %y2=x2;%alpha.*x2+(1-alpha).*x1;
        y1 = [x1(1:xoverPoint) x2(xoverPoint+1:testSuiteSize)];
        y2 = [x2(1:xoverPoint) x1(xoverPoint+1:testSuiteSize)];
    else
        y1 = x1;
        y2= x2;
    end
    
    
end