function y = mirror(x)
%@ typeparameters: t, m, n
%@ types: y: matrix(t,m,n), x: matrix(t,m,n)
%@ ensures: \forall j: int32 . (1 <= j && j <= n ==> all(y(:,j) == x(:,size(x,2)-j+1)))
  i = int32(1);
  y = x;
  while (i <= size(x,1))
  %@ invariant: 1 <= i && i <= size(x,1)+1
  %@ invariant: \forall j: int32 . (1 <= j && j < i ==> all(y(:,j) == x(:,size(x,2)-j+1)))
    y(:,i) = x(:,size(x,2)-i+1)
    i = i+1;
  end
end