function c = matmult_impl(a,b)
%@ typeparameters: n, m, p
%@ types: a: matrix(double,n,m), b: matrix(double,m,p), c: matrix(double,n,p)
%@ ensures: \forall q: int32, k: int32 . ((1 <= q && q <= size(a,1) && 1 <= k && k <= size(b,2)) ==> c(q,k) == sum(a(q,:).*transpose(b(:,k))))
%@ ensures: all(all(c == a*b))
	c = zeros(n,p);
	i = int32(1);
	while (i <= size(a,1))
	%@ invariant: 1 <= i
    %@ invariant: i <= size(a,1)+1
	%@ invariant: \forall q: int32, k: int32 . ((1 <= q && q < i && 1 <= k && k <= size(b,2)) ==> c(q,k) == sum(a(q,:).*transpose(b(:,k))))
		j = int32(1);
		while (j <= size(b,2))
		%@ invariant: 1 <= j
		%@ invariant: j <= size(b,2)+1
		%@ invariant: \forall q: int32, k: int32 . ((1 <= q && q < i && 1 <= k && k <= size(b,2)) ==> c(q,k) == sum(a(q,:).*transpose(b(:,k))))
		%@ invariant: \forall k: int32 . ((1 <= k && k < j) ==> c(i,k) == sum(a(i,:).*transpose(b(:,k))))
		    ar = a(i,:);
	        br = transpose(b(:,j));
	        pr = ar.*br;
	        s = sum(pr); 
			c(i,j) = s;
			j = j+1;
		end
		i = i+1;
   	end
end