function s = bsort_sum(a,perm)
%@ typeparameters: n, m
%@ types: a: matrix(t,m,n), s: matrix(t,m,n), perm: matrix(int32,1,n)
%@ ensures: \forall i: int32, j: int32 . (1 <= i && i <= j && j <= size(a,2) ==> sum(s(:,i)) <= sum(s(:,j)))
%@ ensures: \forall i: int32 . (1 <= i && i <= size(a,2) ==> (1 <= new(perm)(i) && new(perm)(i) <= size(a,2)))
%@ ensures: \forall i: int32, j: int32 . (1 <= i && i < j && j <= size(a,2) ==> new(perm)(i) ~= new(perm)(j))
%@ ensures: \forall i: int32 . (1 <= i && i <= size(a,2) ==> all(s(:,i) == a(:,new(perm)(i))))
  perm = int32(zeros(1,size(a,2)));
  k = int32(1);
  while (k <= size(a,2))
  % invariant: 1 <= k
  % invariant: k <= size(a,2)+1
  %@ invariant: \forall i: int32 . (1 <= i && i < k ==> perm(i) == i)
    perm(k) = k;
    k = k+1;
  end
  while (1 < k)
  % invariant: 1 <= k
  % invariant: k <= size(a,2)+1
  %@ invariant: \forall i: int32, j: int32 . (k <= i && i <= size(a,2) && 1 <= j && j < i ==> sum(a(:,j)) <= sum(a(:,i)))
  % invariant: \forall i: int32 . (1 <= i && i <= size(a,2) ==> (1 <= perm(i) && perm(i) <= size(a,2)))
  %@ invariant: \forall i: int32, j: int32 . (1 <= i && i < j && j <= size(a,2) ==> perm(i) ~= perm(j))
  %@ invariant: \forall i: int32 . (1 <= i && i <= size(a,2) ==> all(a(:,i) == old(a)(:,perm(i))))
    p = 1;
    k = k-1;
    while (p < k)
    % invariant: 1 <= p
    %@ invariant: p <= k
    % invariant: k <= size(a,2)
    %@ invariant: \forall i:int32, j: int32 . (k+1 <= i && i <= size(a,2) && 1 <= j && j < i ==> sum(a(:,j)) <= sum(a(:,i)))
    % invariant: \forall i: int32 . (1 <= i && i <= size(a,2) ==> (1 <= perm(i) && perm(i) <= size(a,2)))
    %@ invariant: \forall i: int32, j: int32 . (1 <= i && i < j && j <= size(a,2) ==> perm(i) ~= perm(j))
    %@ invariant: \forall i: int32 . (1 <= i && i <= size(a,2) ==> all(a(:,i) == old(a)(:,perm(i))))
    %@ invariant: \forall i: int32 . (1 <= i && i < p ==> sum(a(:,i)) <= sum(a(:,p)))
      if (sum(a(:,p+1)) < sum(a(:,p)))
        tmp = a(:,p);
        a(:,p) = a(:,p+1);
        a(:,p+1) = tmp;
        tmp2 = perm(p);
        perm(p) = perm(p+1);
        perm(p+1) = tmp2;
      end
      p = p+1;
    end
  end
  s = a;
end