function y = test(x)
%@ types: x: matrix(double,7,1), y: matrix(double,7,1)
  buf = zeros(50,1);
  y = avg_filter(x,buf);
end

function y = avg_filter(x,buffer)
%@ typeparameters: n, m
%@ types: buffer: matrix(double,n,1), x: matrix(double,m,1), y: matrix(double,m,1)
%@ requires: length(x) <= length(buffer)
%@ ensures: \forall j: int32 . ((1 <= j && j <= length(x)) ==> y(j) == (sum(nscroll(buffer,j))+sum_until(x,j))/double(length(buffer)))
  y = zeros(length(x),1);
  i = int32(1);
  while (i <= length(x))
  % invariant: 1 <= i
  %@ invariant: \forall j: int32 . ((i <= j && j <= length(buffer)) ==> buffer(j) == nscroll(old(buffer),i-1)(j))
  %@ invariant: \forall j: int32 . ((1 <= j && j < i) ==> buffer(j) == x(i-j))
  %@ invariant: \forall j: int32 . ((1 <= j && j < i) ==> y(j) == (sum(nscroll(old(buffer),j))+sum_until(x,j))/double(length(buffer)))
    buffer = nscroll(buffer,1);
    buffer(1) = x(i);
    y(i) = sum(buffer)/double(length(buffer));
    i = i+1;
  end
end

function scrolled = nscroll(buffer,n)
%@ typeparameters: m
%@ types: buffer: matrix(double,m,1), n: int32, scrolled: matrix(double,m,1)
%@ requires: 0 <= n && n <= length(buffer);
%@ ensures: \forall j: int32 . (n+1 <= j && j <= length(buffer) ==> scrolled(j) == buffer(j-n))
%@ ensures: \forall j: int32 . (1 <= j && j <= n ==> scrolled(j) == 0)
  scrolled = buffer;
  i = n+1;
  while (i <= length(buffer))
  % invariant: n+1 <= i
  %@ invariant: \forall j: int32 . (n+1 <= j && j <= i-1 ==> scrolled(j) == buffer(j-n))
    scrolled(i) = buffer(i-n);
    i = i+1;
  end
  i = 1;
  while (i <= n)
  % invariant: 1 <= i
  %@ invariant: \forall j: int32 . (n+1 <= j && j <= length(buffer) ==> scrolled(j) == buffer(j-n))
  %@ invariant: \forall j: int32 . (1 <= j && j <= i-1 ==> scrolled(j) == 0)
    scrolled(i) = 0;
    i = i+1;
  end
end

function y = sum_until(x,i)
%@ typeparameters: m
%@ types: x: matrix(double,m,1), i: int32, y: double
%@ requires: 0 <= i && i <= length(x)
%@ ensures: i == 0 ==> y == 0
%@ ensures: i == 1 ==> y == x(1)
%@ ensures: i > 1 ==> y == sum_until(x,i-1)+x(i)
  if (i == 0)
    y = 0.0
  elseif (i == 1)
    y = x(1)
  else
    y = sum_until(x,i-1)+x(i)
  end
end

