function c = matmult_impl(a,b)
%@ typeparameters: n, m, p
%@ types: a: matrix(double,n,m), b: matrix(double,m,p), c: matrix(double,n,p)
%@ ensures: \forall q: int32, k: int32 . ((1 <= q && q <= size(a,1) && 1 <= k && k <= size(b,2)) ==> c(q,k) == sum(a(q,:).*transpose(b(:,k))))
%@ ensures: all(all(c == a*b))
	c = zeros(n,p);
	for i = 1:size(a,1)
	%@ invariant: \forall q: int32, k: int32 . ((1 <= q && q <= i && 1 <= k && k <= size(b,2)) ==> c(q,k) == sum(a(q,:).*transpose(b(:,k))))
		for j = 1:size(b,2)
		%@ invariant: \forall q: int32, k: int32 . ((1 <= q && q < i && 1 <= k && k <= size(b,2)) ==> c(q,k) == sum(a(q,:).*transpose(b(:,k))))
		%@ invariant: \forall k: int32 . ((1 <= k && k <= j) ==> c(i,k) == sum(a(i,:).*transpose(b(:,k))))
		    ar = a(i,:);
	        br = transpose(b(:,j));
	        pr = ar.*br;
	        s = sum(pr); 
			c(i,j) = s;
		end
   	end
end