function mx = max_sum(x)
%@ types: mx: t, x: matrix(t,m,n)
%@ requires: all(all(0 <= x))
%@ ensures: all(sum(x) <= mx)
%@ ensures: any(sum(x) == mx)
%@ ensures: 0 <= mx
  s = sum(x);
  mx = s(1);
  i = 2;
  while (i <= length(s))
  %@ invariant: \forall j: int32 . (1 <= j && j < i ==> s(j) <= mx)
  %@ invariant: \exists j: int32 . (1 <= j && j < i && s(j) == mx)
    if (mx < s(i))
      mx = s(i);      
    end
    i = i+1;
  end
end
