function f=gauss(A,b)
%@typeparameters: n: int32;
%@types: A: matrix(double, n,n), b: matrix(double, n, 1), f:  matrix(double, n, 1);
%@ensures: all(f == answer(A,b));
   k=1;
   f=b;
   while(k<=length(b))
   %@invariant: all(A*answer(old(A),b)==f);
      if (A(k,k)==0)
          error 'Matrix is singular'
      end
      j = k+1;
      while (j<=length(b))
         f(j) = f(j)-f(k).*A(j,k)/A(k,k); 
         A(j,:) = A(j,:) - A(k,:).*A(j,k)./A(k,k);
         j = j+1;
      end
      k = k+1;
   end
   
   k=length(A);
   while (1<=k)
   %@invariant: all(A*answer(old(A),b)==f);
      f(k)=f(k)/A(k,k);
      A(k,k)=1;
      j=k-1;
      while(1<=j)
      %@invariant: all(A*answer(old(A),b)==f);   
      %@invariant: \forall u:int32, v:int32 . (1<=u && u<=n && u<v && v<=n ==> A(v,u)==0);
          f(j)=f(j)-f(k).*A(j,k);
   		  A(j,k)=0;
   		  j=j-1;
      end
      k = k-1;
   end
end

function f = answer(A,b)
%@typeparameters: n: int32;
%@types: A: matrix(double, n,n), b: matrix(double, n, 1), f:  matrix(double, n, 1);
%@ensures: all(A*f == b);
    f = zeros(n,1);
    assume all(A*f == b);
end