function bin = dec2bin(dec,n)
%@ typeparameters: t <: int32, n
%@ types: bin: matrix(boolean,1,n), dec: t, n: t
%@ requires: 0 <= dec
%@ ensures: ~overflow ==> dec == sum(pow2s(n) .* int32(bin))
    bin = boolean(zeros(1,n));
    b = int32(0);
    powers = pow2s(n);
    overflow = false;
    while (b < length(bin) && ~overflow)
    %@ invariant: 0 <= b && b <= length(bin)
    %@ invariant: \forall i: int32 . (b < i && i <= length(bin) ==> ~bin(i))
    %@ invariant: b < length(bin) ==> old(dec) == dec.*powers(b+1)+sum(powers .* int32(bin))
    %@ invariant: b == length(bin) && ~overflow ==> old(dec) == sum(powers .* int32(bin))
        b = b+1;
        bit = boolean(mod(dec,2));
        bin(b) = bit;
        dec = dec/2;
        if (b == length(bin) && dec > 0)
          overflow = true;
        end
    end
end

function p2s = pow2s(n)
%@ typeparameters: n
%@ types: n: int32, p2s: matrix(int32,1,n)
%@ ensures: p2s(1) == 1
%@ ensures: \forall j: int32 . (2 <= j && j <= n ==> p2s(j) == 2*p2s(j-1))
  p2s = int32(ones(1,n)); 
  for i = 2:length(p2s)
  %@ invariant: p2s(1) == 1
  %@ invariant: \forall j: int32 . (2 <= j && j <= i ==> p2s(j) == 2*p2s(j-1))
    p2s(i) = 2*p2s(i-1);
  end
end