function fibs = fibonacci(n)
%@ typeparameters: n:int32;
%@ types: n:int32, fibs: matrix(double,n,1);
%@ requires: n > 1;
%@ ensures: \forall j:int32 . ((3<=j && j<=n) ==> (fibs(j) == fibs(j-1)+fibs(j-2)));
%@ ensures 'first fibonacci number is 0': fibs(1) == 0;
%@ ensures 'second fibonacci number is 1': fibs(2) == 1;
   i=2;
   fibs=zeros(n,1);
   fibs(1)=0;
   fibs(2)=1;
   while(i<n)
   %@ invariant: 2<=i;
   %@ invariant: fibs(1)==0 && fibs(2)==1; 
   %@ invariant: \forall j:int32 .( (3<=j && j<=i) ==> (fibs(j) == fibs(j-1)+fibs(j-2)));
      i=i+1;
      fibs(i)=fibs(i-1)+fibs(i-2);
   end
end
