function result = mean_sd(input)
%@ typeparameters: n
%@ types: result: matrix(double,1,2), input: matrix(double,1,n)
%@ ensures: result(1) == sum(input)/double(length(input))
%@ ensures: result(2) == sqrt(sum((input-result(1)).^2)/double(length(input)))
  result = zeros(1,2);
  s = 0.0;
  for i = 1:length(input)
  %@ invariant: s == sum_until(input,i)
    s = s+input(i);
  end
  avg = s/double(length(input));
  result(1) = avg;
  s = 0.0;
  sq_devs = zeros(1,length(input))
  for i = 1:length(input)
  %@ invariant: \forall k: int32 . (1 <= k && k <= i ==> sq_devs(k) == (input(k)-result(1)).^2)
  %@ invariant: s == sum_until(sq_devs,i)
  % invariant: 0 <= s
    dev = input(i)-avg;
    sq_dev = dev.^2;
    sq_devs(i) = sq_dev;
    s = s+sq_devs(i);
  end
  sd = sqrt(s/double(length(input)));
  result(2) = sd;
end

function y = sum_until(x,i)
%@ typeparameters: n
%@ types: x: matrix(double,1,n), i: int32, y: double
%@ requires: 0 <= i && i <= length(x)
%@ ensures: i == 0 ==> y == 0
%@ ensures: i == 1 ==> y == x(1)
%@ ensures: i > 1 ==> y == sum_until(x,i-1)+x(i)
  if (i == 0)
    y = 0.0
  elseif (i == 1)
    y = x(1)
  else
    y = sum_until(x,i-1)+x(i)
  end
end