/*
 * Enkhtur Zurgaanjin 199967
 * Ilyas Amin 197399
 * Christian Kaptur 502309
 * 
 * In dieser Klasse werden die Constraints definiert, d.h. die Gleichungen der Constraints:
 * gleichung1 := {(x,y) | (x + 1350)^2 + (y – 1950)^2 >= 3111696}
 * gleichung2 := {(x,y) | (x + 1350)^2 + (y – 1950)^2 <= 3374569}
 * gleichung3 := {(x,y) | (x – 1350)^2 + (y – 1950)^2 >= 4562496}
 * gleichung4 := {(x,y) | (x – 1350)^2 + (y – 1950)^2 <= 5031049}
 * gleichung5 := {(x,y) | (x + 1350)^2 + (y + 1950)^2 >= 6175225}
 * gleichung6 := {(x,y) | (x + 1350)^2 + (y + 1950)^2 <= 6911641}
 * (vergleiche Lösungsblatt)
 */

public class Constraint {
	
	public boolean gleichung1 (long x, long y) {
		return (((x+1350)*(x+1350)+(y-1950)*(y-1950))>=(3111696));
	}
	
	public boolean gleichung2 (long x, long y) {
		return (((x+1350)*(x+1350)+(y-1950)*(y-1950))<=(3374569));
	}
	
	public boolean gleichung3 (long x, long y) {
		return (((x-1350)*(x-1350)+(y-1950)*(y-1950))>=(4562496));
	}
	
	public boolean gleichung4 (long x, long y) {
		return (((x-1350)*(x-1350)+(y-1950)*(y-1950))<=(5031049));
	}
	
	public boolean gleichung5 (long x, long y) {
		return (((x+1350)*(x+1350)+(y+1950)*(y+1950))>=(6175225));
	}
	
	public boolean gleichung6 (long x, long y) {
		return (((x+1350)*(x+1350)+(y+1950)*(y+1950))<=(6911641));
	}
}
