/****************************************************************************
 * Einfuehrung in die kuenstliche Intelligenz - Aufgabe 2					*
 *																			*
 * Copyright (C) 2006 by 	Alexander Keller 	(19 61 67), 				*
 *							Maik Burandt		(19 66 63), 				*
 *							Andre Stephan   	(19 70 50)					*
 ***************************************************************************/
#include <iostream>
#include <string>
#include <sstream>
#include <cmath>
#include <map>
#include <vector>

using namespace std;

const double PI = 3.1415926535;
double FEHLER = 0.25;		// +/- FEHLER in Grad

//KLASSEN UND STRUKTUREN:

/*Die Fahnen haben alle ein Codierung (im Uhrzeigersinn):
	rechts oben: 22
	rechts unten: 41
	links unten: 33
	links oben: 14 */
struct codierung{
	int x;
	int y;
};

class Rechteck{
public:
	Rechteck(){
		for(int i=0;i<2;i++){
			dxl[i] = 0.0;
			dxr[i] = 0.0;
			dy[i] = 0.0;
		}
	}
	double dxl[2];		//Einschraenkung auf x-Achse (links von Fahne)		Fehler: [-1Grad, +1Grad]
	double dxr[2];		//Einschraenkung auf x-Achse (rechts von Fahne)		Fehler: [-1Grad, +1Grad]
	double dy[2];		//Einschraenkung auf y-Achse						Fehler: [-1Grad, +1Grad]
};

class Kreis{
public:
	Kreis(){
		Radius[0] = 0.0;
		Radius[1] = 0.0;
	}
	double Radius[2];			//Fehler: [-FEHLER Grad, +FEHLER Grad]
};

class Schnitt{
public:
	map<string,vector<double> >s1;	// 2 Schnittepunkte * 2 Kreise * 2 (+-FEHLER)
};

/* Position setzt sich zusammen aus den gesehenen Fahnenwinkeln (siehe Beschreibung) Wxxx und der
daraus resultierenden Entfernung zu den Fahnen Exxx */
class Position{
public:
	Position(){
		Wvorn		= 3.15;			// 3.15 ausgemessen aus Bild 7,3cm x 5,6cm
		Wlinks		= 2.175;		// 2.175 -"-
		Wrechts		= 2.625;		// 2.625 -"-
		WEvorn		= 24.0;			// 24.0  -"-
		WElinks		= 22.5;			// 22.5	 -"-
	}
	double Wvorn;
	double Wlinks;
	double Wrechts;
	double WEvorn;
	double WElinks;
};

/* Schnitt aller lokal konsistenten Einschraenkungen mit x und y Angaben*/
class GlobaleEinschraenkung{
public:
	GlobaleEinschraenkung(){
		dxl = -3000.0;
		dxr = 3000.0;
		dyo = 2000.0;
		dyu = -2000.0;
	}
	double dxl;
	double dxr;
	double dyo;
	double dyu;
};

class Fahne : public Kreis, public Rechteck, public Schnitt{
public:
	Fahne(){};
	Fahne(int x1, int y1){
		code.x = x1;
		code.y = y1;

		/* Aufgrund der Codierung der Fahnen kann mit diesem Algorithmus einfach die x und y Position
	   der entsprechenden Fahne bestimmt werden! */
		x = pow(-1.0, code.x) * 1350.0;
		y = pow(-1.0, code.y) * 1950.0;

		ostringstream temp;
		temp << (x1*10 + y1);
		fname = temp.str();

		cout << "Fahne(" << code.x << code.y << "): " << endl;
		cout << "\tX: " << x << endl;
		cout << "\tY: " << y << endl;
	}

	void Kreisbahn(Position p);
	double x;			//x-Position der Fahne auf dem Feld
	double y;			//y-Position der Fahne auf dem Feld
	codierung code;		//Nummerierung der Fahnen
	string fname;
};

class Hilfspunkt : public Fahne{
public:
	Hilfspunkt(int x1, int y1, double winkel, int f){
		code.x = x1;
		code.y = y1;

		ostringstream temp;
		temp << (100 + x1*10 + y1);
		fname = temp.str();

		s = sqrt(pow(1650.0, 2.0) + pow(50.0, 2.0));

		Radius[0] = s/(2.0 * sin((winkel+f*FEHLER)/180*PI));
		/* weil die Schnittpunktfunktion 2 Radien erwartet, ein wenig geschummelt, aber so musste nichts
		   an den Datenstrukturen geaendert werden */

		Radius[1] = s/(2.0 * sin((winkel+f*FEHLER)/180*PI));
		x = -2325 - sqrt(-625 + (pow(Radius[0], 2.0)/730));
		y = pow(-1.0, code.y)* 27.0 * x + pow(-1.0, code.y)*64750;
		
		cout << "Hilfspunkt(" << fname << "): " << endl;
		cout << "\tX: " << x << endl;
		cout << "\tY: " << y << endl;
		cout << "\tRadius: " << Radius[0] << endl;
	}
	double s;
};

//MEMBERFUNKTIONEN:
void Fahne::Kreisbahn(Position p){
	cout << endl << "Berechne Entfernung zu Fahne(" << code.x << code.y << "): " << endl;
	
	/* Die Fahnen sind 100mm breit */
	int r;
	r = 100 / 2;	// Radius einer Fahne

	/* Es wird die Entfernung zu jeder Fahne berechnet:
		Entfernung = (Fahnenbreite/2)/tan(Fahnenwinkel/2) + RadiusFahne */

	/* Es wird jeweils ins Bogenmass umgerechnet!!! */

	if(fname == "14"){
		// FahneVorn
		Radius[0] = r/(tan(((p.Wvorn-FEHLER)/2)/180*PI)) + r;
		Radius[1] = r/(tan(((p.Wvorn+FEHLER)/2)/180*PI)) + r;
	}else if(fname == "33"){
		// FahneLinks
		Radius[0] = r / (tan(((p.Wlinks-FEHLER)/2)/180*PI)) + r;
		Radius[1] = r / (tan(((p.Wlinks+FEHLER)/2)/180*PI)) + r;
	}else if(fname == "22"){
		// FahneRechts
		Radius[0] = r / (tan(((p.Wrechts-FEHLER)/2)/180*PI)) + r;
		Radius[1] = r / (tan(((p.Wrechts+FEHLER)/2)/180*PI)) + r;
	}
	
	cout << "\tEntfernung bei -" << FEHLER << " Grad Abweichung = " << Radius[0] << "mm" << endl;
	cout << "\tEntfernung bei +" << FEHLER << " Grad Abweichung = " << Radius[1] << "mm" << endl;
}


//FUNKTIONSDEKLARATIONEN:

void C1(Fahne *f);		//lokal konsistente Einschraenkungen
void C2(GlobaleEinschraenkung *GE, Fahne fvorn, Fahne flinks, Fahne frechts, Hilfspunkt h1, Hilfspunkt h3);	//global konsistente Einschraenkung auf Basis lokalkonsistenter E.
void C3(GlobaleEinschraenkung *GE, Fahne fvorn, Fahne flinks);	//global konsistente Einschraenkung auf Basis der Schnittpunkte der Fahnenkreise

void schnittpunkt(GlobaleEinschraenkung GE, Fahne *f1, Fahne *f2);
double minimum2(double f1, double f2);
double minimum3(double f1, double f2, double f3);
double maximum2(double f1, double f2);
double maximum3(double f1, double f2, double f3);
double maxInt(vector<double> ok, int start);
double minInt(vector<double> ok, int start);
void punktinIntervall(GlobaleEinschraenkung *GE, vector<double> *ok, Fahne f1);
void printGE(GlobaleEinschraenkung *GE);

//FUNKTIONSDEFINITIONEN:

/* Aufruf des Programms ueber Parameter (Fahnenwinkel): FahneVorn FahneLinks FahneRechts 
   Diese Winkel haben wir berechnet durch: Fahnenbreite auf dem Bild in mm * 0.75 Grad, da
   unser Bild 73mm breit ist und dies einem Winkel von 55 Grad entspricht */
int main(int argc, char *argv[])
{
	/* Anfangs kommt das ganze Spielfeld in betracht */
	GlobaleEinschraenkung GE;

	/* Startposition (Standardwerte, die aus den Bildern abgelesen wurden) */
	Position Pos;

	/* Fahnen initialisieren */
	cout << endl << "*******************************************************************************" << endl;
	cout << "Initialisiere Fahnenpositionen:" << endl;
	Fahne fvorn(1,4);
	Fahne flinks(3,3);
	Fahne frechts(2,2);
	cout << "*******************************************************************************" << endl;

	cout << endl << "*******************************************************************************" << endl;
	if(argc == 7){
		//Parameter angegeben
		cout << "Parameter wurden gesetzt!" << endl;
		FEHLER		= atof(argv[1]);
		Pos.Wvorn	= atof(argv[2]);
		Pos.Wlinks	= atof(argv[3]);
		Pos.Wrechts = atof(argv[4]);
		Pos.WEvorn	= atof(argv[2]);
		Pos.WElinks	= atof(argv[3]);
	}
	else{
		cout << endl << "Es wurden keine Parameter angegeben -> Standardwerte werden genutzt!" << endl;
		cout << "Aufruf: Programm Fehler WinkelFahneVorn WinkelFahneLinks WinkelFahneRechts\nWinkelEckeVorn WinkelEckeLinks (in Grad)" << endl;
	}
	cout << "*******************************************************************************" << endl;

	cout << endl << "*******************************************************************************" << endl;
	cout << "\tWinkel FahneVorn: " << Pos.Wvorn << endl;
	cout << "\tWinkel FahneLinks: " << Pos.Wlinks << endl;
	cout << "\tWinkel FahneRechts: " << Pos.Wrechts << endl;
	cout << "\tWinkel EckeVorn: " << Pos.WEvorn << endl;
	cout << "\tWinkel EckeLinks: " << Pos.WElinks << endl;
	cout << "*******************************************************************************" << endl;

	/* Ecken initialisieren */
	cout << endl << "*******************************************************************************" << endl;
	cout << "Initialisiere Hilfspunkte:" << endl;
	// ueber die beiden Ecken, die nach vorn und links zu sehen sind
	Hilfspunkt h1(1, 4, Pos.WEvorn, -1);
	Hilfspunkt h2(1, 4, Pos.WEvorn, 1);
	Hilfspunkt h3(3, 3, Pos.WElinks, -1);
	Hilfspunkt h4(3, 3, Pos.WElinks, 1);
	cout << "*******************************************************************************" << endl;

	/* Es wird die Entfernung zu jeder Fahne berechnet:
		Entfernung = (Fahnenbreite/2)/tan(Fahnenwinkel/2) + RadiusFahne */
	cout << endl << "*******************************************************************************" << endl;
	fvorn.Kreisbahn(Pos);
	flinks.Kreisbahn(Pos);
	frechts.Kreisbahn(Pos);	
	cout << "*******************************************************************************" << endl;
	
	/* Hilfspunkte ueber Ecken berechnen */
	cout << endl << "*******************************************************************************" << endl;
	
	cout << "*******************************************************************************" << endl;

	/* Nun werden die Einschraenkungen fuer jede Fahne entsprechend der moeglichen
	   Kreisbahn, die sich aus der Entfernung ergibt, berechnet */
	cout << endl << "*******************************************************************************" << endl;
	C1(&fvorn);
	C1(&flinks);
	C1(&frechts);
	C1(&h1);
	C1(&h3);
	cout << "*******************************************************************************" << endl;

	cout << endl << "*******************************************************************************" << endl;
	//Schnittpunkt von Fahne(14) und Fahne(22)
	cout << endl << "Berechne Schnittpunkt des Kreises um Fahne(14) und Fahne(22):" << endl;
	schnittpunkt(GE, &fvorn, &frechts);
	//Schnittpunkt von Fahne(14) und Fahne(33)
	cout << endl << "Berechne Schnittpunkt des Kreises um Fahne(14) und Fahne(33):" << endl;
	schnittpunkt(GE, &fvorn, &flinks);
	//Schnittpunkt von Fahne(22) und Fahne(33)
	cout << endl << "Berechne Schnittpunkt des Kreises um Fahne(33) und Fahne(22):" << endl;
	schnittpunkt(GE, &flinks, &frechts);
	//Schnittpunkt von Ecke(14) und Ecke(33)
	cout << "*******************************************************************************" << endl;

	/* Berechne global konsistente Einschraenkung ueber die Entfernung */
	cout << endl << "*******************************************************************************" << endl;
	C2(&GE, fvorn, flinks, frechts, h1, h3);
	cout << "*******************************************************************************" << endl;

	/* Berechne neue global konsistente Einschraenkung -> Schnittpunkt der Fahnenkreise.
	   Ist ein Intervall, wegen den Abweichungen (FEHLER) */
	cout << endl << "*******************************************************************************" << endl;
	C3(&GE, fvorn, flinks);
	cout << "*******************************************************************************" << endl;

	cout << "FERTIG...(Taste druecken zum Beenden)..." << endl;
	getchar();
	return EXIT_SUCCESS;
}

void C1(Fahne *f){
	for(int i=0;i<2;i++){
		f->dxl[i] = f->x - f->Radius[i];
		f->dxr[i] = f->x + f->Radius[i];
		f->dy[i] = f->y - pow(-1.0, f->code.y) * f->Radius[i];

		/* Automatische Wertkorrekturen, falls Punkte ausserhalb des Spielfeldes liegen! 
		   Wird durch Domaenen eingeschraenkt. */
		if(f->dxl[i] < -3000){
			f->dxl[i] = -3000;
		}
		if(f->dxr[i] > 3000){
			f->dxr[i] = 3000;
		}
		if(f->dy[i] < -2000){
			f->dy[i] = -2000;
		}
		if(f->dy[i] > 2000){
			f->dy[i] = 2000;
		}

		cout << endl << "lokal konsistente Einschraenkung fuer ";
		
		if((f->fname == "114") || (f->fname == "133")){
			cout << "Hilfspunkt";
		}else{
			cout << "Fahne";
		}
		cout << "(" << f->fname << ")";

		if(i==0){
			cout << " bei -" << FEHLER << " Grad Abweichung: " << endl;
		}else{
			cout << " bei +" << FEHLER << " Grad Abweichung: " << endl;
		}
		cout << "\t X: [" << f->dxl[i] << ", " << f->dxr[i] << "]" << endl;
		cout << "\t Y: [" << f->y << ", " << f->dy[i] << "]" << endl;
	}
}

void C2(GlobaleEinschraenkung *GE, Fahne fvorn, Fahne flinks, Fahne frechts, Hilfspunkt h1, Hilfspunkt h3){
	cout << endl << "Berechne global konsistente Einschraenkung mit Entfernung zu Fahnen:" << endl;
	cout << "\tVorherige Einschraenkung: " << endl;
	printGE(GE);

	cout << endl << "\tNeue Einschraenkung: " << endl;
	/* finde groesstes linke x, wobei nur -FEHLER Grad betrachtet werden muss! */
	GE->dxl = maximum3(fvorn.dxl[0], flinks.dxl[0], frechts.dxl[0]);
	GE->dxl = maximum3(GE->dxl, h1.dxl[0], h3.dxl[0]);

	/* finde kleinstes rechte x, wobei nur -FEHLER Grad betrachtet werden muss! */
	GE->dxr = minimum3(fvorn.dxr[0], flinks.dxr[0], frechts.dxr[0]);
	GE->dxr = minimum3(GE->dxr, h1.dxr[0], h3.dxr[0]);

	/* finde groesstes untere x, wobei nur -FEHLER Grad betrachtet werden muss! */
	GE->dyo = maximum3(fvorn.dy[0], flinks.dy[0], frechts.dy[0]);
	
	//GE->dyo = minimum3(GE->dyo, h1.dy[0], h3.dy[0]);

	/* finde kleinstes obere x, wobei nur -FEHLER Grad betrachtet werden muss! */
	GE->dyu = minimum3(fvorn.dy[0], flinks.dy[0], frechts.dy[0]);
	//GE->dyu = minimum3(GE->dyu, h1.dy[0], h3.dy[0]);

	printGE(GE);
}

void C3(GlobaleEinschraenkung *GE, Fahne fvorn, Fahne flinks){
	/* Nun muss anhand der Schnittpunkte erneut eingeschraenkt werden. Hierbei werden Schnittpunkte
	   ausserhalb der aktuellen global konsistenten Einschraenkung ignoriert, da sie nicht zu
	   einer Verbesserung des Ergebnisses beitragen */

	cout << endl << "Berechne global konsistente Einschraenkung Schnittpunkten der Fahnenkreisbahnen:" << endl;
	cout << "\tVorherige Einschraenkung: " << endl;
	printGE(GE);

	cout << endl << "\tNeue Einschraenkung: " << endl;
	vector<double> ok;

	punktinIntervall(GE, &ok, fvorn);
	punktinIntervall(GE, &ok, flinks);

	// Suche MaxX
	GE->dxr = maxInt(ok, 0);
	// Suche MinX
	GE->dxl = minInt(ok, 0);
	// Suche MaxY
	GE->dyo = maxInt(ok, 1);
	// Suche MinY
	GE->dyu = minInt(ok, 1);
	printGE(GE);
}


void schnittpunkt(GlobaleEinschraenkung GE, Fahne *f1, Fahne *f2){
	for(int i=0;i<2;i++){
		if(i==0){
			cout << "\tFehler: -" << FEHLER << " Grad:" << endl;
		}else{
			cout << "\tFehler: +" << FEHLER << " Grad:" << endl;
		}		

		/*	I		(x - Fahne1.x)^2 + (y - Fahne1.y)^2 = r1^2
			<=>		x^2 - (2*Fahne1.x)*x + Fahne1.x^2 + y^2 - (2*Fahne1.y)*y + Fahne1.y^2 = r1^2

			II		(x - Fahne2.x)^2 + (y - Fahne2.y)^2 = r2^2
			<=>		x^2 - (2*Fahne2.x)*x + Fahne2.x^2 + y^2 - (2*Fahne2.y)*y + Fahne2.y^2 = r1^2

			I - II	-(2*Fahne1.x)*x + (2*Fahne2.x)*x + Fahne1.x^2 - Fahne2.x^2 - (2*Fahne1.y)*y + (2*Fahne2.y)*y + Fahne1.y^2 - Fahne2.y^2 = r1^2 - r2^2
			<=>		x(2*Fahne2.x-2*Fahne1.x) + y(2*Fahne2.y-2*Fahne1.y) + Fahne1.x^2 - Fahne2.x^2 + Fahne1.y^2 - Fahne2.y^2 = r1^2 - r2^2
			<=>		x=(- y(2*Fahne2.y-2*Fahne1.y) + r1^2-r2^2- Fahne1.x^2 + Fahne2.x^2 - Fahne1.y^2 + Fahne2.y^2)/(2*Fahne2.x-2*Fahne1.x)

			a = r1^2-r2^2- Fahne1.x^2 + Fahne2.x^2 - Fahne1.y^2 + Fahne2.y^2
			b = 2*Fahne2.x-2*Fahne1.x
			c = 2*Fahne1.y - 2*Fahne2.y
			=> x = (c * y + a)/b

			in I einsetzen
					((c*y + a)/b)^2 - 2*Fahne1.x*((c*y + a)/b) + Fahne1.x^2 + y^2 - 2*Fahne1.y*y + Fahne1.y^2 = r1^2
			<=>		((c^2 * y^2 + 2*c*a*y + a^2)/b^2) - (2*Fahne1.x*c*y + 2*Fahne1.x*a)/b + Fahne1.x^2 + y^2 - 2*Fahne1.y*y + Fahne1.y^2 = r1^2
			<=>		c^2 * y^2 + 2*c*a*y + a^2 - 2*Fahne1.x*c*y*b - 2*Fahne1.x*a*b + Fahne1.x^2*b^2 + y^2*b^2 - 2*Fahne1.y*y*b^2 + Fahne1.y^2*b^2 - r1^2*b^2 = 0
			<=>		(c^2 + b^2)*y^2 + (2*c*a - 2*Fahne1.x*c*b - 2*Fahne1.y*b^2)*y + a^2 - 2*Fahne1.x*a*b + Fahne1.x^2*b^2 + Fahne1.y^2*b^2 - r1^2*b^2 = 0
			<=>		y^2 + ((2*c*a - 2*Fahne1.x*c*b - 2*Fahne1.y*b^2)/(c^2 + b^2))*y + a^2/(c^2 + b^2) - 2*Fahne1.x*a*b/(c^2 + b^2) + Fahne1.x^2*b^2/(c^2 + b^2) + Fahne1.y^2*b^2/(c^2 + b^2) - r1^2*b^2/(c^2 + b^2) = 0

			pq-Formel:
					y1 = -(((2*c*a - 2*Fahne1.x*c*b - 2*Fahne1.y*b^2)/(c^2 + b^2)))/2 + sqrt( (((2*c*a - 2*Fahne1.x*c*b - 2*Fahne1.y*b^2)/(c^2 + b^2))^2)/4 - (a^2/(c^2 + b^2) - 2*Fahne1.x*a*b/(c^2 + b^2) + Fahne1.x^2*b^2/(c^2 + b^2) + Fahne1.y^2*b^2/(c^2 + b^2) - r1^2*b^2/(c^2 + b^2)) )
					y2 = -(((2*c*a - 2*Fahne1.x*c*b - 2*Fahne1.y*b^2)/(c^2 + b^2)))/2 - sqrt( (((2*c*a - 2*Fahne1.x*c*b - 2*Fahne1.y*b^2)/(c^2 + b^2))^2)/4 - (a^2/(c^2 + b^2) - 2*Fahne1.x*a*b/(c^2 + b^2) + Fahne1.x^2*b^2/(c^2 + b^2) + Fahne1.y^2*b^2/(c^2 + b^2) - r1^2*b^2/(c^2 + b^2)) )
				x1:
					x^2 - (2*Fahne1.x)*x + Fahne1.x^2 + y1^2 - (2*Fahne1.y)*y1 + Fahne1.y^2 - r1^2 = 0
					p = -(2*Fahne1.x)
					q = Fahne1.x^2 + y1^2 - (2*Fahne1.y)*y1 + Fahne1.y^2 - r1^2
					x1 = -((p)/2) + sqrt( (p^2)/4 - q )
				x2:
					x^2 - (2*Fahne1.x)*x + Fahne1.x^2 + y1^2 - (2*Fahne1.y)*y1 + Fahne1.y^2 - r1^2 = 0
					p = -(2*Fahne1.x)
					q = Fahne1.x^2 + y1^2 - (2*Fahne1.y)*y1 + Fahne1.y^2 - r1^2
					x2 = -((p)/2) - sqrt( (p^2)/4 - q )
				x3:
					x^2 - (2*Fahne1.x)*x + Fahne1.x^2 + y2^2 - (2*Fahne1.y)*y2 + Fahne1.y^2 - r1^2 = 0
					p = -(2*Fahne1.x)
					q = Fahne1.x^2 + y2^2 - (2*Fahne1.y)*y2 + Fahne1.y^2 - r1^2
					x3 = -((p)/2) + sqrt( (p^2)/4 - q )
				x4:
					x^2 - (2*Fahne1.x)*x + Fahne1.x^2 + y2^2 - (2*Fahne1.y)*y2 + Fahne1.y^2 - r1^2 = 0
					p = -(2*Fahne1.x)
					q = Fahne1.x^2 + y2^2 - (2*Fahne1.y)*y2 + Fahne1.y^2 - r1^2
					x3 = -((p)/2) - sqrt( (p^2)/4 - q )
		*/
		double a; 
		double b; 
		double c; 
		double p; 
		double q;
		double y1, y2, ya, yb;
		double x1, x2, x3, x4, xa, xb;
		vector<double> ko;
		ko.resize(0);

		/*TEST:
		f1->x=-1.0;
		f1->y=1.0;
		f1->Radius[0]=1.0;
		f1->Radius[1]=1.0;

		f2->x=1.0;
		f2->y=1.0;
		f2->Radius[0]=1.0;
		f2->Radius[1]=1.0;
		//TESTENDE */


		/* Test auf keinen Schnittpunkt (Dreiecksungleichung, wie es beispielsweise bei +FEHLER vorkommt, da man nicht an alle Fahnen
		   herantreten kann, sodass danach immer noch ein Schnittpunkt der Entfernungskreise existiert. Da dieser Fehler
		   jedoch vorhanden ist, muss die global konsistente Einschraenkung darauf angepasst werden! */
		
		if(sqrt(static_cast<double>((f1->x-f2->x)*(f1->x-f2->x) + (f1->y-f2->y)*(f1->y-f2->y))) > static_cast<double>(abs(f1->Radius[i] + f2->Radius[i]))){
			cout << "\t\tEs gibt keinen Schnittpunkt der beiden Kreise!" << endl;
			ko.resize(4*i);
		}else{
			a = pow(f1->Radius[i],2.0) - pow(f2->Radius[i],2.0) - pow(f1->x,2.0) + pow(f2->x,2.0) - pow(f1->y,2.0) + pow(f2->y,2.0);
			b = 2*f2->x - 2*f1->x;
			c = 2*f1->y - 2*f2->y;

			/* Feststellen, wieviele Schnittpunkte es gibt */
			if(f1->x == f2->x){
				//y
				y1 = -1 * (((2*c*a - 2*f1->x*c*b - 2*f1->y*pow(b,2.0))/(pow(c,2.0) + pow(b,2.0))))/2;
				p = -1 * (2*f1->x);

				if(((abs(f1->y)+abs(f1->Radius[i])) - (abs(f2->y)+f2->Radius[i]) == 0)){
					//Kreise liegen uebereinander, nur eine Beruehrung in einem Punkt => als eine Begrenzung waehlen
					cout << "\tKreise uebereinander (auf x-Achse), Beruehrung in einem Punkt." << endl;

					//x:
					q = pow(f1->x,2.0) + pow(y1,2.0) - (2*f1->y)*y1 + pow(f1->y,2.0) - pow(f1->Radius[i],2.0);
					x1 = -1 * ((p)/2) + sqrt( (pow(p,2.0))/4 - q );

					ko.resize(2+i*2);
					f1->s1[f2->fname].resize(2+i*2);
					ko[0+i*2] = x1;
					ko[1+i*2] = y1;

					if(i==0){
						f1->s1[f2->fname][0] = ko[0];
						f1->s1[f2->fname][1] = ko[1];
					}else{
						f1->s1[f2->fname][2] = ko[2];
						f1->s1[f2->fname][3] = ko[3];
					}

					cout << "\t\tSchnittpunkt: [" << x1 << ", " << y1 << "]" << endl;
				}else{
					//Kreise liegen uebereinander, 2 Beruehrungen => als eine Begrenzung waehlen
					cout << "\tKreise uebereinander (auf x-Achse), Beruehrung in zwei Punkten." << endl;
					
					//x1
					q = pow(f1->x,2.0) + pow(y1,2.0) - (2*f1->y)*y1 + pow(f1->y,2.0) - pow(f1->Radius[i],2.0);
					x1 = -1 * ((p)/2) + sqrt( (pow(p,2.0))/4 - q );

					//x2
					q = pow(f1->x,2.0) + pow(y1,2.0) - (2*f1->y)*y1 + pow(f1->y,2.0) - pow(f1->Radius[i],2.0);
					x2 = -1 * ((p)/2) - sqrt( (pow(p,2.0))/4 - q );
					
					ko.resize(4+i*4);
					f1->s1[f2->fname].resize(4+i*4);
					ko[0+i*4] = x1;
					ko[1+i*4] = y1;
					ko[2+i*4] = x2;
					ko[3+i*4] = y1;

					if(i==0){
						f1->s1[f2->fname][0] = ko[0];
						f1->s1[f2->fname][1] = ko[1];
						f1->s1[f2->fname][2] = ko[2];
						f1->s1[f2->fname][3] = ko[3];
					}else{
						f1->s1[f2->fname][4] = ko[4];
						f1->s1[f2->fname][5] = ko[5];
						f1->s1[f2->fname][6] = ko[6];
						f1->s1[f2->fname][7] = ko[7];
					}

					cout << "\t\tSchnittpunkt_1: [" << x1 << ", " << y1 << "]" << endl;
					cout << "\t\tSchnittpunkt_2: [" << x2 << ", " << y1 << "]" << endl;
				}
			}else if(f1->y == f2->y){
				//y:
				y1 = -1 * (((2*c*a - 2*f1->x*c*b - 2*f1->y*pow(b,2.0))/(pow(c,2.0) + pow(b,2.0))))/2 + 
				sqrt( (pow(((2*c*a - 2*f1->x*c*b - 2*f1->y*pow(b,2.0))/(pow(c,2.0) + pow(b,2.0))),2.0))/4 - 
				(pow(a,2.0)/(pow(c,2.0) + pow(b,2.0)) - 2*f1->x*a*b/(pow(c,2.0) + pow(b,2.0)) + 
				pow(f1->x,2.0)*pow(b,2.0)/(pow(c,2.0) + pow(b,2.0)) + pow(f1->y,2.0)*pow(b,2.0)/(pow(c,2.0) + 
				pow(b,2.0)) - pow(f1->Radius[i],2.0)*pow(b,2)/(pow(c,2.0) + pow(b,2.0))) );

				//x:
				p = -1 * (2*f1->x);
				q = pow(f1->x,2.0) + pow(y1,2.0) - (2*f1->y)*y1 + pow(f1->y,2.0) - pow(f1->Radius[i],2.0);
				x1 = -1 * ((p)/2) + sqrt( (pow(p,2.0))/4 - q );

				if(((abs(f1->x)+abs(f1->Radius[i])) - (abs(f2->x)+abs(f2->Radius[i])) == 0)){
					//Kreise liegen nebeneinander, nur eine Beruehrung in einem Punkt => als eine Begrenzung waehlen
					cout << "\tKreise nebeneinander (auf y-Achse), Beruehrung in einem Punkt." << endl;
					//4
					ko.resize(2+i*2);
					f1->s1[f2->fname].resize(2+i*2);
					ko[0+i*2] = x1;
					ko[1+i*2] = y1;

					if(i==0){
						f1->s1[f2->fname][0] = ko[0];
						f1->s1[f2->fname][1] = ko[1];
					}else{
						f1->s1[f2->fname][2] = ko[2];
						f1->s1[f2->fname][3] = ko[3];
					}

					cout << "\t\tSchnittpunkt: [" << x1 << ", " << y1 << "]" << endl;
				}else{
					//Kreise liegen nebeneinander, 2 Beruehrungen => als eine Begrenzung waehlen
					cout << "\tKreise nebeneinander (auf y-Achse), Beruehrung in zwei Punkten." << endl;

					y2 = -1 * (((2*c*a - 2*f1->x*c*b - 2*f1->y*pow(b,2.0))/(pow(c,2.0) + pow(b,2.0))))/2 - 
					sqrt( (pow(((2*c*a - 2*f1->x*c*b - 2*f1->y*pow(b,2.0))/(pow(c,2.0) + pow(b,2.0))),2.0))/4 - 
					(pow(a,2.0)/(pow(c,2.0) + pow(b,2.0)) - 2*f1->x*a*b/(pow(c,2.0) + pow(b,2.0)) + 
					pow(f1->x,2.0)*pow(b,2.0)/(pow(c,2.0) + pow(b,2.0)) + pow(f1->y,2.0)*pow(b,2.0)/(pow(c,2.0) + 
					pow(b,2.0)) - pow(f1->Radius[i],2.0)*pow(b,2)/(pow(c,2.0) + pow(b,2.0))) );
					//8
					ko.resize(4+i*4);
					f1->s1[f2->fname].resize(4+i*4);
					ko[0+i*4] = x1;
					ko[1+i*4] = y1;
					ko[2+i*4] = x1;
					ko[3+i*4] = y2;

					if(i==0){
						f1->s1[f2->fname][0] = ko[0];
						f1->s1[f2->fname][1] = ko[1];
						f1->s1[f2->fname][2] = ko[2];
						f1->s1[f2->fname][3] = ko[3];
					}else{
						f1->s1[f2->fname][4] = ko[4];
						f1->s1[f2->fname][5] = ko[5];
						f1->s1[f2->fname][6] = ko[6];
						f1->s1[f2->fname][7] = ko[7];
					}

					cout << "\t\tSchnittpunkt_1: [" << x1 << ", " << y1 << "]" << endl;
					cout << "\t\tSchnittpunkt_2: [" << x1 << ", " << y2 << "]" << endl;
				}
			}else{
				/* 2 Schnittpunkte moeglich => nur den waehlen, der in der bisherigen Einschraenkung liegt,
				   sind beide drin, so den auesseren waehlen */
				cout << "\tBeruehrung in zwei Punkten." << endl;

				y1 = -1 * (((2*c*a - 2*f1->x*c*b - 2*f1->y*pow(b,2.0))/(pow(c,2.0) + pow(b,2.0))))/2 + 
				sqrt( (pow(((2*c*a - 2*f1->x*c*b - 2*f1->y*pow(b,2.0))/(pow(c,2.0) + pow(b,2.0))),2.0))/4 - 
				(pow(a,2.0)/(pow(c,2.0) + pow(b,2.0)) - 2*f1->x*a*b/(pow(c,2.0) + pow(b,2.0)) + 
				pow(f1->x,2.0)*pow(b,2.0)/(pow(c,2.0) + pow(b,2.0)) + pow(f1->y,2.0)*pow(b,2.0)/(pow(c,2.0) + 
				pow(b,2.0)) - pow(f1->Radius[i],2.0)*pow(b,2)/(pow(c,2.0) + pow(b,2.0))) );

				y2 = -1 * (((2*c*a - 2*f1->x*c*b - 2*f1->y*pow(b,2.0))/(pow(c,2.0) + pow(b,2.0))))/2 - 
				sqrt( (pow(((2*c*a - 2*f1->x*c*b - 2*f1->y*pow(b,2.0))/(pow(c,2.0) + pow(b,2.0))),2.0))/4 - 
				(pow(a,2.0)/(pow(c,2.0) + pow(b,2.0)) - 2*f1->x*a*b/(pow(c,2.0) + pow(b,2.0)) + 
				pow(f1->x,2.0)*pow(b,2.0)/(pow(c,2.0) + pow(b,2.0)) + pow(f1->y,2.0)*pow(b,2.0)/(pow(c,2.0) + 
				pow(b,2.0)) - pow(f1->Radius[i],2.0)*pow(b,2)/(pow(c,2.0) + pow(b,2.0))) );

				//x:
				p = -1 * (2*f1->x);

				//x1
				q = pow(f1->x,2.0) + pow(y1,2.0) - (2*f1->y)*y1 + pow(f1->y,2.0) - pow(f1->Radius[i],2.0);
				x1 = -1 * ((p)/2) + sqrt( (pow(p,2.0))/4 - q );
				//x2
				q = pow(f1->x,2.0) + pow(y1,2.0) - (2*f1->y)*y1 + pow(f1->y,2.0) - pow(f1->Radius[i],2.0);
				x2 = -1 * ((p)/2) - sqrt( (pow(p,2.0))/4 - q );

				//x3
				q = pow(f1->x,2.0) + pow(y2,2.0) - (2*f1->y)*y2 + pow(f1->y,2.0) - pow(f1->Radius[i],2.0);
				x3 = -1 * ((p)/2) + sqrt( (pow(p,2.0))/4 - q );

				//x4
				q = pow(f1->x,2.0) + pow(y2,2.0) - (2*f1->y)*y2 + pow(f1->y,2.0) - pow(f1->Radius[i],2.0);
				x4 = -1 * ((p)/2) - sqrt( (pow(p,2.0))/4 - q );

				if(f2->x>f1->x){
					if(f2->y>f1->y){
						xa = x1;
						ya = y1;
						xb = x3;
						yb = y2;

						//cout << "\t\tSchnittpunkt_1: [" << x1 << ", " << y1 << "]" << endl;
						//cout << "\t\tSchnittpunkt_2: [" << x3 << ", " << y2 << "]" << endl;
					}else{
						xa = x3;
						ya = y2;
						xb = x1;
						yb = y1;

						//cout << "\t\tSchnittpunkt_1: [" << x3 << ", " << y2 << "]" << endl;
						//cout << "\t\tSchnittpunkt_2: [" << x1 << ", " << y1 << "]" << endl;
					}
				}else{
					if(f2->y>f1->y){
						xa = x4;
						ya = y2;
						xb = x2;
						yb = y1;

						//cout << "\t\tSchnittpunkt_1: [" << x4 << ", " << y2 << "]" << endl;
						//cout << "\t\tSchnittpunkt_2: [" << x2 << ", " << y1 << "]" << endl;
					}else{
						xa = x2;
						ya = y1;
						xb = x4;
						yb = y2;
						//cout << "\t\tSchnittpunkt_1: [" << x2 << ", " << y1 << "]" << endl;
						//cout << "\t\tSchnittpunkt_2: [" << x4 << ", " << y2 << "]" << endl;
					}
				}
				ko.resize(4+i*4);
				f1->s1[f2->fname].resize(4+i*4);
				ko[0+i*4] = xa;
				ko[1+i*4] = ya;
				ko[2+i*4] = xb;
				ko[3+i*4] = yb;

				if(i==0){
					f1->s1[f2->fname][0] = ko[0];
					f1->s1[f2->fname][1] = ko[1];
					f1->s1[f2->fname][2] = ko[2];
					f1->s1[f2->fname][3] = ko[3];
				}else{
					f1->s1[f2->fname][4] = ko[4];
					f1->s1[f2->fname][5] = ko[5];
					f1->s1[f2->fname][6] = ko[6];
					f1->s1[f2->fname][7] = ko[7];
				}
				cout << "\t\tSchnittpunkt_1: [" << xa << ", " << ya << "]" << endl;
				cout << "\t\tSchnittpunkt_2: [" << xb << ", " << yb << "]" << endl;
			}
		}
	}
}


double maximum2(double f1, double f2){
	if(f1>f2) return f1;
	return f2;
}

double maximum3(double f1, double f2, double f3){
	if(maximum2(f1, f2) > f3) return maximum2(f1, f2);
	return f3;
}

double minimum2(double f1, double f2){
	if(f1 < f2) return f1;
	return f2;
}

double minimum3(double f1, double f2, double f3){
	if(minimum2(f1, f2) < f3) return minimum2(f1, f2);
	return f3;
}

double maxInt(vector<double> ok, int start){
	int anzahl = 0;
	double max;
	max = -3000 + (start * 1000);
	anzahl = static_cast<int>(ok.size());

	for(int j=start;j<anzahl-(1-start);j=j+2){
		if(ok[j]>=max){
			max = ok[j];
		}
	}
	return max;
}

double minInt(vector<double> ok, int start){
	int anzahl = 0;
	double min;
	min = +3000 - (start * 1000);
	anzahl = static_cast<int>(ok.size());

	for(int j=start;j<anzahl-(1-start);j=j+2){
		if(ok[j]<=min){
			min = ok[j];
		}
	}
	return min;
}

void punktinIntervall(GlobaleEinschraenkung *GE, vector<double> *ok, Fahne f1){
	int i = 0;
	int anzahl = 0;
	vector<double> temp;

	if(f1.fname=="14"){
		// durchsuche Fahne fvorn nach Schnittpunkten mit frechts
		anzahl = static_cast<int>(f1.s1["22"].size());
		temp = f1.s1["22"];

		for(i=0;i<anzahl-1;i=i+2){
			// teste ob der Punkt innnerhalb global konsistenter Einschraenkung => Filter
			//   x							x					y						y
			if(((temp[i]>GE->dxl) && (temp[i]<GE->dxr)) && ((temp[i+1]<GE->dyo) && (temp[i+1]>GE->dyu))){
				ok->push_back(temp[i]);
				ok->push_back(temp[i+1]);
			}
		}
	}
	
	if(f1.fname=="14"){
		// durchsuche Fahne fvorn nach Schnittpunkten mit flinks
		anzahl = static_cast<int>(f1.s1["33"].size());
		temp = f1.s1["33"];
	}

	if(f1.fname=="33"){
		// durchsuche Fahne flinks nach Schnittpunkten mit frechts
		anzahl = static_cast<int>(f1.s1["22"].size());
		temp = f1.s1["22"];
	}else if(f1.fname=="114"){
		// durchsuche Ecke evorn nach Schnittpunkten mit elinks
		anzahl = static_cast<int>(f1.s1["133"].size());
		temp = f1.s1["133"];
	}

	for(i=0;i<anzahl-1;i=i+2){
		// teste ob der Punkt innnerhalb global konsistenter Einschraenkung => Filter
		//   x							x					y						y
		if(((temp[i]>GE->dxl) && (temp[i]<GE->dxr)) && ((temp[i+1]<GE->dyo) && (temp[i+1]>GE->dyu))){
			ok->push_back(temp[i]);
			ok->push_back(temp[i+1]);
		}
	}
}
void printGE(GlobaleEinschraenkung *GE){
	cout << "\t\tMinimales X: " << GE->dxl << endl;
	cout << "\t\tMaximales X: " << GE->dxr << endl << endl;
	cout << "\t\tMinimales Y: " << GE->dyu << endl;
	cout << "\t\tMaximales Y: " << GE->dyo << endl;
}

