package betriebpraktikanten;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.vecmath.Point2i;

/**
 * Reprsentiert das Spielfeld.
 * @author lars
 *
 */
public class Spielfeld extends JFrame {
	
	/** linke Spielfeldbegrenzung (X Dimension) */
	public final static int xMinValue = -3000; 
	/** rechte Spielfeldbegrenzung (X Dimension) */
	public final static int xMaxValue = 3000; 

	/** untere Spielfeldbegrenzung (Y Dimension)*/
	public final static int yMinValue = -2000; 
	/** obere Spielfeldbegrenzung (Y Dimension) */
	public final static int yMaxValue = 2000; 
	
	/** minimaler Richtungswinkel */
	public final static float thetaMinValue = (float) 0.0;
	/** maximaler Richtungswinkel */
	public final static float thetaMaxValue = (float) (2*Math.PI);
	
	private static final long serialVersionUID = 5030881422973098886L;
	private Graphics2D graphics = null;
	private BufferedImage image = null;
	private ImageComponent imageComponent = null;

	/** umrechnungsfaktor p_x(realwelt) * f = p_x(image) */ 
	private float xFactor;
	/** umrechnungsfaktor p_y(realwelt) * f = p_y(image) */ 
	private float yFactor;

	/**
	 * Erstellt ein Spielfeld mit dem Namen <i>name</i>.
	 * @param name der Name des Fensters
	 * @throws IOException
	 */
	public Spielfeld(String name, Point pos) throws IOException {
		File imageFile = new File ("src/image/spielfeld.bmp");
		image = ImageIO.read(imageFile);
		float xDim = Math.abs(Spielfeld.xMaxValue-Spielfeld.xMinValue)+1;
		float yDim = Math.abs(Spielfeld.yMaxValue-Spielfeld.yMinValue)+1;
		xFactor = image.getWidth()/xDim;
		yFactor = image.getHeight()/yDim;
		graphics = image.createGraphics();
		this.setTitle(name);
		imageComponent = new ImageComponent(image);
		this.setLocation(pos);
		this.getContentPane().add(imageComponent);
		this.pack();
		this.setResizable(false);
		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
	}

	/**
	 * Stellt die Malfarbe <i>color</i> ein.
	 * @param color Die Malfarbe
	 */
	public void setDrawColor (Color color) {
		graphics.setColor(color);
	}

	/**
	 * Zeichnet den Punkt <i>p</i>, indem ein Kreuz der Lnge 3 an diesem Punkt gezeichnet wird.
	 * @param p Der Punkt
	 */
	public void drawPoint (Point2i p) {
		drawPoint (p,1); 
	}

	/**
	 * Zeichnet den Punkt <i>p</i>, indem ein Kreuz der Lnge 2*length+1 an diesem Punkt gezeichnet wird.
	 * @param p Der Punkt
	 * @param length halbe breite des Kreuzes
	 */
	public void drawPoint (Point2i p, int length) {
		// spielfeld-koordinaten in grafische koordinaten umrechnen
		Point2i g = getPicturePoint(p); 
		// und zeichen
		graphics.drawLine(g.x-length,g.y, g.x+length,g.y);
		graphics.drawLine(g.x,g.y-length, g.x,g.y+length);
	}

	/**
	 * Zeichnet eine Linie von start nach ende.
	 * @param start Der Startpunkt
	 * @param ende Der Endpunkt
	 */
	public void drawLine(Point2i start, Point2i ende) {
		Point2i gStart = getPicturePoint(start); 
		Point2i gEnde = getPicturePoint(ende); 
		graphics.drawLine(gStart.x,gStart.y, gEnde.x,gEnde.y);
	}
	
	/**
	 * Rechnet Spielfeld-Koordinaten in grafische Koordinaten um
	 * @param p Spielfeld-Punkt
	 * @return Grafischer Punkt
	 */
	private Point2i getPicturePoint (Point2i p) {
		// wie? koordinatenursprung nach (xMinValue,yMinValue) verschieben und y an x spiegeln
		int x = (int) ((p.x+Math.abs(xMinValue))*xFactor);
		int y = (int) ((-p.y+Math.abs(yMinValue))*yFactor);
		return new Point2i(x,y);
	}
}
