package betriebpraktikanten;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

import javax.swing.JComponent;

/**
 * Reprsentiert den grafischen Teil des Spielfeldes.
 * 
 * @author lars
 *
 */
public class ImageComponent extends JComponent {
	private static final long serialVersionUID = 8974781770341077454L;
	private Image image;

	/**
	 * Erstellt eine Bildkomponente aus <i>image</i>.
	 * 
	 * @param image Hintergrundbild
	 */
	public ImageComponent(Image image) {
		this.image = image;
		this.setPreferredSize(new Dimension(image.getWidth(null), image.getHeight(null)));
	}

	/**
	 * Malt die hinterlegte Grafik.
	 */
	public void paintComponent(Graphics g) {
		g.drawImage(image, 0, 0, null);
	}
}
