package betriebpraktikanten;

/**
 * Reprsentiert ein Constraint. Es wird sowohl die original Zeichenkette, als auch eine bearbeitete
 * Version vorgehalten (siehe Konstruktor).
 * 
 * @author lars
 *
 */
public class Constraint {
	
	/** original */
	private String original;
	
	/** abkrzungen ersetzt */
	private String constraint;
	
	/** benutzt 'posX' oder 'posY' */ 
	private boolean isVectorConstraint;
	
	/** benutzt 'theta' */
	private boolean isAngleConstraint;
	
	/**
	 * Ersetzt bestimmte mathematische Kurzformen durch ihr Pendant in java.lang.Math.*
	 * <p>
	 * ARCSIN, ARCCOS, ARCTAN, SIN, COS, TAN, ABS, SQRT, POW, EXP, PI
	 * 
	 * @param original Zeichenkette mit Abkrzung
	 * @return Zeichenkette mit richtigem Java-Code
	 */
	static String replaceMathExp (String original) {
		original = original.replace("ARCSIN","Math.asin");
		original = original.replace("ARCCOS","Math.acos");
		original = original.replace("ARCTAN","Math.atan");
		original = original.replace("SIN","Math.sin");
		original = original.replace("COS","Math.cos");
		original = original.replace("TAN","Math.tan");
		original = original.replace("ABS","Math.abs");
		original = original.replace("SQRT","Math.sqrt");
		original = original.replace("POW","Math.pow");
		original = original.replace("EXP","Math.exp");
		original = original.replace("PI","Math.PI");
		return original;
	}
	
	public String toString () {
		return "Constraint ===>\n\toriginal   = '"+original+
		                     "'\n\tconstraint = '"+constraint+"'"+
                              "\n\tisVector   = "+isVectorConstraint+
                              "\n\tisAngle    = "+isAngleConstraint;
	}
	
	/**
	 * Erstellt ein Constraint. ARCSIN, ARCCOS, ARCTAN, SIN, COS, TAN, ABS, SQRT, POW, EXP und PI
	 * werden durch ihr Pendant in java.lang.Math.* ersetzt.
	 * 
	 * @param original Zeichenkette mit dem Constraint.
	 */
	public Constraint (String original) {
		this.original = original;
		this.constraint = replaceMathExp(original);
		this.isVectorConstraint = (this.constraint.indexOf(PoseListe.POSE_X) >= 0) || (this.constraint.indexOf(PoseListe.POSE_Y) >= 0); 
		this.isAngleConstraint = this.constraint.indexOf(PoseListe.POSE_THETA) >= 0; 
	}

	/**
	 * Liefert die original Zeichenkette
	 * @return Original Zeichenkette
	 */
	public String getOriginal() {
		return original;
	}

	/**
	 * Liefert die bearbeitete Zeichenkette
	 * @return Bearbeitete Zeichenkette
	 */
	public String getConstraint() {
		return constraint;
	}
	
	/**
	 * Wird im Constraint der Blickwinkel des Roboters benutzt?
	 * @return Wird im Constraint der Blickwinkel des Roboters benutzt? 
	 */
	public boolean isAngleConstraint() {
		return isAngleConstraint;
	}

	/**
	 * Wird im Constraint die Position des Roboters benutzt? 
	 * @return Wird im Constraint die Position des Roboters benutzt? 
	 */
	public boolean isVectorConstraint() {
		return isVectorConstraint;
	}
}
