using System;
using System.Collections.Generic;
using System.Text;

namespace ConstrainPropagierung
{
    class MyPoint
    {
        public Double x = 0;
        public Double y = 0;

        public MyPoint(Double Ax, Double Ay)
        {
            x = Ax;
            y = Ay;
        }
    }

    class Consts
    {
        public Int32 CamHeight = 50;

        public Double BearingAngleF1 = -3.0; //Peilungswinkel Fahne1 
        public Double BearingAngleF2 = 25.5; //Peilungswinkel Fahne2 
        public Double BearingAngleF3 = 2.0; //Peilungswinkel Fahne3 

        //Flaggen Koordinaten
        public MyPoint F1 = new MyPoint(-1350, -1950); //F1 = ( -1350 / - 1950) in mm
        public MyPoint F2 = new MyPoint(-1350, 1950); //F2 = ( -1350 /   1950)  in mm
        public MyPoint F3 = new MyPoint(1350, 1950); //F3 = (  1350 /   1950)   in mm     

        public Double DistanceEpsilon = 50; //Messungsfehler der Distanz um einen bereich aufzuspannen
        //ohne epsilon wre die Position durch die 3 Fahnenentfernungen exakt bestimmbar was sie jedoch 
        //durch messfehler nicht ist
        
        public Int32 HeightOfF1 = 260; //hhe von Fahne 1 in mm
        public Int32 HeightOfF2 = 340; //hhe von Fahne 2 in mm
        public Int32 HeightOfF3 = 300; //hhe von Fahne 3 in mm 

        public Int32 RealFlagHeight = 400; //40cm Flaggenhhe echt

        public Double DistanceToF1()
        {//entfernung von roboter zu Fahne 1   
            return Math.Abs(Math.Tan(BearingAngleF1) * CamHeight);

            //Double d = RealFlagHeight / HeightOfF1;
            //return Math.Abs(d * Math.Cos(BearingAngleF1));
        }
        public Double DistanceToF2()
        {//entfernung von roboter zu Fahne 2  
            return Math.Abs(Math.Tan(BearingAngleF2) * CamHeight);

            //Double d = RealFlagHeight / HeightOfF2;
            //return Math.Abs(d * Math.Cos(BearingAngleF2));
        }
        public Double DistanceToF3()
        {//entfernung von roboter zu Fahne 3  
            return Math.Abs(Math.Tan(BearingAngleF3) * CamHeight);

            //Double d = RealFlagHeight / HeightOfF3;
            //return Math.Abs(d * Math.Cos(BearingAngleF3));
        }

        public Double SpaceToMiddleline()
        {
            return Math.Abs(Math.Tan(68) * CamHeight);
        }

    }
}
