package positionsbestimmung;

/**
 * Stellt ein Spielfeld mit den Maen x und y bereit.
 */

public class Spielfeld {
	private int length_x;
	private int length_y;
	private int[][] feld;
	private int durchlauf;
	
	/** Eine Klasse, die das Spielfeld bereitstellt. Je hher ein Wert ist,
	 * desto wahrscheinlicher ist er.
	 * @author root
	 *
	 */
	
	public Spielfeld (int x, int y) {
		length_x = x;
		length_y = y;
		durchlauf = 0;
		feld = new int[length_x][length_y];
		for (int i = 0; i < feld.length; i++) {
			for (int j = 0; j < feld[i].length; j++) {
				feld[i][j] = 0;	//Am Anfang ist keine Pos. wahrscheinlich!
			}
		}
	}
	
	public int getFeld(int x, int y) {
		return feld[x][y];
	}
	
	public int getLength_x() {
		return length_x;
	}
	
	public int getLength_y() {
		return length_y;
	}
	
	public void setDurchlauf(int durchlauf) {
		this.durchlauf = durchlauf;
	}
	
	public void setFeld(int x, int y, int wert) {
		feld[x][y] = wert;
	}
	
	public void increaseFeld(int x, int y) {
		feld[x][y]++;
	}
	
	public int getDurchlauf() {
		return durchlauf;
	}
	
}
