package positionsbestimmung;

public class Peilung {

	/*
	 * Der Absolute Fehler in deg kann hier festgelegt werden.
	 */
	
	static double delta = 1;
	
	/*
	 * Hier werden die gesehenen Objekte mit ihren Peilungen eingetragen.
	 * Die Einheit fr Lngen ist Millimeter.
	 */
	
	static Objekt[] objekteMitHhe = {
		// Ort, Hhe, Peilung Vertikal, Peilung Horizontal
		new Objekt(new Punkt(165, 5), 40, 
				new Winkel(  7.2, true), new Winkel(-98, true)),	//Fahne links-unten
		new Objekt(new Punkt(165,  394), 40, 
				new Winkel( 10.8, true), new Winkel( 18, true)),	//Fahne links-oben
		new Objekt(new Punkt( 434,  394), 40, 
				new Winkel(  9.4, true), new Winkel( 98, true))		//Fahne rechts-oben
	};
	
	static Objekt[] objekteOhneHhe = {
		new Objekt(new Punkt(-2700, -1800), 0, 
				new Winkel(0, true), new Winkel(-70, true)),		//Ecke links-unten
		new Objekt(new Punkt(-2700,  1799), 0, 
				new Winkel(0, true), new Winkel( -8, true))			//Ecke links-oben
	};
	
	/* 
	 * Fr das konkrete Problem haben wir der Einfachheit halber nur das zweite
	 * Verfahren implementiert, da wir drei Objekte mit gegebener Hhe zur 
	 * Verfgung haben und somit ohne Probleme mit dieser Methode bereits 
	 * eine Flche angeben knnen. Die Genauigkeit ist hier eh nicht so hoch, da
	 * wir die Werte mit Lineal aus dem Bild abgemessen haben.
	 */
	
	/**
	 * Einschrenken des Wertebereichs mit Constraint jedes Objektes mit Hhe. 
	 */

	private static void constraintPropagierung(Objekt o, Spielfeld feld) {
		int grenzeAuen = 0;
		int grenzeInnen = 0;
		
		
		//Berechnen des Auen- und des Innenradius in Abhngigkeit von delta.
		int radiusAuen = (int) (o.getHhe()/
					Math.tan(o.getPeilung_vertikal().getRad()) + delta) + 1;
		int radiusInnen = (int) (o.getHhe()/
					Math.tan(o.getPeilung_vertikal().getRad() - delta)) - 1;
		
		/*
		 * Wir setzen fr jeden x-Wert jeden y-Wert, der sich zwischen den 
		 * Kreisen befindet. Wir zerschneiden den Kreis parallel zu x-Achse
		 * in Streifen und berechnen fr jeden dieser Streifen dann die maximale
		 * konsistente Einschrnkung der y-Koordinaten.
		 * 
		 */
		
		for (int 	i = 0; i <= (int)radiusAuen;	i++ ) {
			
			grenzeAuen = (int) Math.sqrt(Math.pow(radiusAuen, 2) 
					- Math.pow(Math.abs(i - o.getOrt().getX_Koordinate()), 2)) + 1; //+1, damit keine Lsung verloren geht.
			
			if(radiusInnen > Math.abs(o.getOrt().getX_Koordinate() - i)) {
				grenzeInnen = (int) Math.sqrt(Math.pow(radiusInnen, 2) 
					- Math.pow(Math.abs(i - o.getOrt().getX_Koordinate()), 2)) - 1; //-1 damit keine Lsung verloren geht.
			} else {
				grenzeInnen = 0;
			}
						
			/* 
			 * Die Werte werden nur fr einen Quadranten berechnet und dann 
			 * gespiegelt. Die Grenzen des Spielfeldes sind zu beachten.
			 */
			for (int j = grenzeInnen; j <= grenzeAuen; j++) {
				if (o.getOrt().getX_Koordinate() - i >= 0 
						&& o.getOrt().getY_Koordinate() + j < feld.getLength_y()) {
					feld.increaseFeld(o.getOrt().getX_Koordinate() - i,
							o.getOrt().getY_Koordinate() + j);
				} 
				if (o.getOrt().getX_Koordinate() - i >= 0
						&& o.getOrt().getY_Koordinate() - j >= 0) {
					feld.increaseFeld(o.getOrt().getX_Koordinate() - i,
							o.getOrt().getY_Koordinate() - j);
				} 
				if (o.getOrt().getX_Koordinate() + i < feld.getLength_x()
						&& o.getOrt().getY_Koordinate() - j >= 0) {
					feld.increaseFeld(o.getOrt().getX_Koordinate() + i,
							o.getOrt().getY_Koordinate() - j);
				} 
				if (o.getOrt().getX_Koordinate() + i < feld.getLength_x()
						&& o.getOrt().getY_Koordinate() + j < feld.getLength_y()) {
					feld.increaseFeld(o.getOrt().getX_Koordinate() + i,
							o.getOrt().getY_Koordinate() + j);
				}
			}
		}
		
		/*
		 * Bei jedem Constraint werden die Einschrnkungen auf das Feld addiert.
		 * Die Felder, die zum Schluss den Wert von feld.durchlauf haben, liegen
		 * in allen Einschrnkungen und sind somit die gesuchten.
		 */
		
		feld.setDurchlauf(feld.getDurchlauf() + 1);
	}
	
	public static void main(String[] args) {
		//Das Spielfeld wird erzeugt, mit einer Auflsung von 1cm.
		Spielfeld feld = new Spielfeld(600, 400);
		
		//Fr jedes Objekt mit Hhe wird der Constraint propagiert.
		for (int i = 0; i < objekteMitHhe.length; i++) {
			constraintPropagierung(objekteMitHhe[i], feld);
		}
		
		//Fr die Ausgabe wird ein Koordinatensystem mit Breite 78 erzeugt.
		char[][] ksys = 
			new char[78][(78*feld.getLength_y())/(3*feld.getLength_x())];
		for (int q = 0; q < ksys.length; q++) {
			for (int r = 0; r < ksys[q].length; r++) {
				ksys[q][r] = ' ';
			}
		}
		
		//Eintragen in das Koordinatensystem und Ausgabe der Lsungen
		int zhler = 0;
		for (int i = 0; i < feld.getLength_x(); i++) {
			for (int j = 0; j < feld.getLength_y(); j++) {
				if (feld.getFeld(i, j) == feld.getDurchlauf()) {
					zhler++;
					System.out.println("[" +(i-feld.getLength_x()/2)+ ";" 
							+(j-feld.getLength_y()/2)+ "] ");
					ksys[(i*ksys.length)/feld.getLength_x()]
					     [(j*ksys[0].length)/feld.getLength_y()] = 'X';
				}
			}
		}
		
		//Ausgabe der Anzahl der Lsungen
		System.out.println("Zhler: " + zhler + "\n");
		
		//Ausgabe des Koordinatensystems
		System.out.println("/\\ Y-Achse");
		for (int q = ksys[0].length - 1; q >= 0; q--) {
			System.out.print("| ");
			for(int r = 0; r < ksys.length; r++) {
				System.out.print(ksys[r][q]);
			}
			System.out.println();
		}
		System.out.print("|");
		for (int berta = 0; berta < 77; berta++) {
			System.out.print("-");			
		}
		System.out.println(">");
		System.out.println("X-Achse");
	}

}