/* Constraint, beschraenkt die Y-Position des Roboters auf einen Bereich bzgl. eines Referenzpunktes,
in Abhaengigkeit von seiner X-Position und dem Intervall der gemessenen Distanz zum Referenzpunkt
*/
public class YDistToReferencePointConstraint extends BinConstraint {
	ReferencePoint rp;

	// Konstruktor
	public YDistToReferencePointConstraint(Variable x, Variable y, ReferencePoint rp) {
		super(x,y);
		this.rp = rp;
	}

	// Bedingung: fuer jedes (x,y)-Paar muss gelten:
	// rp.dist.lower <= sqrt(sqr(x-rp.x)+sqr(y-rp.y)) <= rp.dist.upper
	public boolean constraint(int y, int x) {
		int d = (int)Math.round(Math.sqrt(Constants.sqr(x-rp.x)+Constants.sqr(y-rp.y)));
		return
			(d <= rp.dist.upper) &&
			(d >= rp.dist.lower);
	}
}