import java.util.TreeSet;

// Binaere Constraint
public class BinConstraint extends Constraint {
	
	// var1 wird durch var2 beschraenkt
	public Variable var1, var2;
	
	// Konstruktur, klar
	public BinConstraint(Variable var1, Variable var2) {
		this.var1 = var1;
		this.var2 = var2;	
	}
	
	/* Wird von erbenden Klassen ueberladen, boolescher Ausdruck der eine Kombination aus Werten von var1 und var2 als gueltig kennzeichnet (oder nicht */
	public boolean constraint(int v1, int v2) {
		return true;	
	}
	
	/*
	Schraenkt die obere und untere Grenze fuer var1 in Hinblick auf var2 und die constraint ein.
	Werden keine moeglichen Werte fuer var1 gefunden, (das schliesst ein: auch die alten Grenzen sind ungueltig) wird eine Ausnahme geworfen, da eine Inkonsistenz in den Ausgangsdaten vorliegen muss.
	*/
	public boolean apply()  throws InconsistencyException {
		// findet insgesamt eine Veraenderung des Wertebereichs statt?
		boolean isChanged = false;
		// wird im jeweiligen Suchlauf ein gueltiges Wertepaar gefunden?
		boolean isFound = false;
		
		// neue untere Grenze suchen, dazu von der unteren zur oberen Grenze von var1 iterieren
		for(int v1 = var1.lower; v1<=var1.upper;v1++) {
			// fuer aktuellen var1-Wert noch nichts gefunden
			isFound = false;
			// im Intervall von var2 nach einem passenden Wert zu v1 suchen
			for(int v2 = var2.lower; v2<=var2.upper;v2++)
				// erfuellt Wertepaar die Bedingung?
				if (constraint(v1, v2)) {
					/*ja: wenn sich dadurch die untere Grenze aendert hat sich insgesamt der Intervall von var1 geaendert. Der Intervall wird aktualisiert, es wird gekennzeichnet das ein Wert gefunden wurde, und die Suche wird abgebrochen */					
					if (v1 > var1.lower) 	isChanged = true;
						var1.lower = v1;
						isFound = true;
						break;
					
				}
			// wenn ein Wert gefunden wurde, kann die Suche beendet werden
			if (isFound) break;
		}
		// wenn kein Wert gefunden wurde, Ausnahme wegen Inkonsistenz
		if (! isFound) throw new InconsistencyException(this);
		
		// analog fuer die obere Grenze
		for(int v1 = var1.upper; v1>=var1.lower;v1--) {
			isFound = false;
			for(int v2 = var2.lower; v2<=var2.upper;v2++)
				if (constraint(v1, v2)) {
					if (v1 < var1.upper) 	isChanged = true;
						var1.upper = v1;
						isFound = true;
						break;
					
				}
			if (isFound) break;
		}
		if (! isFound) throw new InconsistencyException(this);		
		
		return isChanged;
	}
}
