%====================================================%
%  SIMULATION EINES BIOLOIDS                         %
%  (C) 16.12.2005                                    %
%  Heinrich Mellmann                                 %
%====================================================%
% dynamics: beschreibt das physikalische Modell des  %
%           BioLoids                                 %
%====================================================%
% Eingabe:
%   x(1) - alpha; 
%   x(2) - beta; 
%   x(3) - l Laenge des Beins; 
%
%   x(4)-x(6) - Ableitungen von x(1)-x(3); 
%
%   t - akueller Zeitpunkt
%
% Ausgabe:
%   x' - Ableitung des Vektors x nach t;
%

function derivative = dynamics( t, x )

% Konstanten (Massen der Massepunkte)
m_a = 30;
m_b = 1;
m_d = 0.5;

% Laengen starer Verbindungen
l_a = 1.5;
l_b = 1;

% grenzwerte des Linearen Gelenks
l_min = 0.5;
l_max = 1.5;

% Erdbeschleunigung
g = 9.81;


derivative = zeros(6,1);

% ------------------ TO DO --------------------------------------
% an diese Stelle soll die GDGL eingetragen werden welches das Modell
% des BioLoids beschreibt;
% ------------------ TO DO --------------------------------------
derivative(1) = x(4);
derivative(2) = x(5);
derivative(3) = x(6);
derivative(4) = 0;
derivative(5) = 0;
derivative(6) = 0;
% ------------------ TO DO --------------------------------------

% BSP.:
%   simuliert den BioLoid reduziert auf ein einfaches Pendulum :)
%   (zum Test einfach einkommentieren)
%
derivative(4) = -g/x(3)*sin(x(1)+pi);
