%====================================================%
%  SIMULATION EINES BioLoid                          %
%  (C) 16.12.2005                                    %
%  Heinrich Mellmann                                 %
%====================================================%
% USEAGE:
%       bioloid(t_end);
% wobei t_end ist ein optionaler Parameter, der die Zeit 
% angibt bis zu der simuliert werden soll (d.h. wie lange
% simuliert werden soll;
%
% - es muss stets gelten t_end >= 0;
%
function bioloid( varargin )

% Anfangs- und End-zeitpunkt der Simulation
t_start=0; 

if nargin == 0
    t_end = 10;
else
    t_end = max(varargin{1},0);
end

x_0 = init;

%Schritweite fr die numrische Integration
dt = 0.02;
% Loesung im Schritt 0 :)
x = x_0;
%Zeit 
t = t_start;


% ausgabe
draw(x, t);
pause

% zeitintervalle zweischen den ausgabeframes
display_dt= 0.01;


t_last_display = 0;

% hier kommt die eigentliche Simulation
for t = t_start:dt:t_end
        
    % berechne die approximation an der Stelle t+h
    [x t] = integrator('dynamics', 'runge-kutta', x, t, dt);
  
    % ausgeben
    if (t - t_last_display > display_dt)
        draw(x, t);
        t_last_display = t;
    end
end

