%====================================================%
%  SIMULATION EINES BioLoid                          %
%  (C) 11.01.2006                                 %
%  Heinrich Mellmann                                 %
%====================================================%
% init: beschreibt die Anfangsbedingungen fr die    %
%       Simulation des BioLoiden                     %
%====================================================%
function [x_0] = init()

%--------------------------------------------------------------------------
% Anfangsbedingungen
% [alpha(t), beta(t), l(t),alpha'(t), beta'(t), l'(t)]
% Bem.: die Parameter  alpha'(t), beta'(t), l'(t) beschreiben
% die Anfangsgeschwindigkeiten der jeweiligen Gelenke;
%--------------------------------------------------------------------------

%% der Roboter kippt
% x_0=[   pi/6, % alpha(t)
%         pi/4, % beta(t)
%         1,    % l(t)
%         0,    % alpha'(t)
%         0,    % beta'(t)
%         0     % l'(t)
%     ];

% der Roboter steh aurecht
x_0=[   0, % alpha(t)
        0, % beta(t)
        1,    % l(t)
        0,    % alpha'(t)
        0,    % beta'(t)
        0     % l'(t)
    ];


%%--------------globale Konstanten-----------------------------------------
global ma mb la lb lmin lmax g;

% Konstanten (Massen der Massepunkte)
ma = 2;
mb = 0.5;


% Laengen starer Verbindungen
la = 1.5;
lb = 1;

% grenzwerte des Linearen Gelenks
lmin = 0.5;
lmax = 1.5;

% Erdbeschleunigung
g = 9.81;


