%====================================================%
%  SIMULATION EINES BIOLOIDS                         %
%  (C) 11.01.2006                                    %
%  Heinrich Mellmann                                 %
%====================================================%
% dynamics: beschreibt das physikalische Modell des  %
%           BioLoids                                 %
%====================================================%
% Eingabe:
%   x(1) - alpha; 
%   x(2) - beta; 
%   x(3) - l Laenge des Beins; 
%
%   x(4)-x(6) - Ableitungen von x(1)-x(3); 
%
%   t - akueller Zeitpunkt
%
% Ausgabe:
%   x' - Ableitung des Vektors x nach t;
%

function derivative = dynamics( t, x, u )

global ma mb la lb lmin lmax g;


derivative = zeros(6,1);

% ------------- Beschreibung des dynamischen Modells ----------------------
derivative(1) = x(4);
derivative(2) = x(5);
derivative(3) = x(6);


t0 = mb*(la^2 + lb^2 - 2*la*lb*cos(x(2)))+2*mb*(la-lb*cos(x(2)))*x(3) + (ma+mb)*x(3)^2;
t1 = (la*mb+(ma+mb)*x(3))*(g*sin(x(1))-2*x(4)*x(6)) + lb*mb*(-g*sin(x(1)+x(2))-(la+x(3))*sin(x(2))*x(5)*(2*x(4)+x(5))+2*cos(x(2))*x(4)*x(6));
t2 = -(lb*mb*sin(x(2)));
t3 = lb*mb*(-lb+cos(x(2))*(la+x(3)));

% derivative(4) = t1/t0 + t3/t0*derivative(5)+ t2/t0*derivative(6);


s1 = -g*sin(x(1)+x(2))+(la+x(3))*sin(x(2))*x(4)^2+2*cos(x(2))*x(4)*x(6);
s2 = -(lb-cos(x(2))*(la+x(3)));
s3 = -sin(x(2));

% derivative(5) = u(1)/lb + s1/lb + s2/lb*derivative(4) + s3/lb*derivative(6);



k0 = ma+mb;
k1 = -g*(ma+mb)*cos(x(1))+(la*mb+(ma+mb)*x(3))*x(4)^2-lb*mb*cos(x(2))*(x(4)+x(5))^2;
k2 = -lb*mb*sin(x(2));


% derivative(6) = u(2)/k0 + k1/k0 + k2/k0*derivative(4) + k2/k0*derivative(5);

% loesung des LGS

M = [ -1     t3/t0  t2/t0
      s2/lb  -1     s3/lb
      k2/k0  k2/k0  -1   ];
  
B = [-t1/t0
     -(u(1)+s1)/lb
     -(u(2)+k1)/k0];

 derivative(4:6) = M\B;
 

 
% ------------- Simulation des Begrenzten Linargelenk----------------------

    d8 = derivative(6);

    if((x(3) >= lmax & x(6) > 0) | (x(3) <= lmin & x(6) < 0))
           
        y = x;
        y(6) = 0;
        if(x(3) >= lmax)
            y(3) = lmax;
        else
            y(3) = lmin;
        end
        u(3) = -(ma+mb)*derivative(6);
        derivative = dynamics(t,y,u); 
       
    end
    
    if((x(3) >= lmax & x(6) == 0 & d8 > 0) | (x(3) <= lmin & x(6) == 0 & d8 < 0))
       
        M = [ -1     t3/t0  t2/t0
              s2/lb  -1     s3/lb
              0 0  -1   ];

        B = [-t1/t0
             -(u(1)+s1)/lb
             0];

        derivative(4:6) = M\B;
         
    end
    
    %----------------------------------------------------------------------
   
