%====================================================%
%  SIMULATION EINES BioLoid                          %
%  (C) 11.01.2006                                    %
%  Heinrich Mellmann                                 %
%====================================================%
% draw: Zeichnet den BioLoid                         %
%====================================================%

function draw(q, t)

    % verallgemeinerte Koordinaten
    alpha = q(1);
    beta = q(2);
    length = q(3);

    %%Konstanten
    length_a = 1.5;
    length_b = 1;

    % erstelle das Bild
    hFig = figure(25);
    set(hFig,'DoubleBuffer','on','NumberTitle','off',...
      'Name','Inverted Pendulum Simulation');

    pos = get(hFig,'Position');
    
    clf; 
    hold on;
    title(['t = ', num2str(t)]);

    % kameraposition ( der Waagen befindet sich stets im Mittelpunkt
    % des Bildes)
    xcamera = 0;

    % grenzen fuer die achsen
    ymin = -5;
    ymax = 5;
    xmin = xcamera-5;
    xmax = xcamera+5;

    % draw the ground
    h = line([xmin;xmax],[0,0]);
    set(h,'Color',[0 0 0]);
    axis image;
    axis([xmin xmax ymin ymax]);

    %%-----------------------------------------------------------------
    % Koordinaten der Massepunkte
    A = [-sin(alpha), cos(alpha)]*length;
    B = [-sin(alpha), cos(alpha)]*(length+length_a);
    C = B + [sin(alpha+beta), -cos(alpha+beta)]*length_b;

    % Verbindungslinien
    line([0,A(1),B(1),C(1)],[0,A(2),B(2),C(2)],'LineWidth',2.0,'Color',[0 0 1]);
    plot([A(1),C(1)],[A(2),C(2)],'-o',...
                'MarkerEdgeColor',[1 1 1],...
                'MarkerFaceColor',[0.1 0.1 0.1],...
                'MarkerSize',10,...
                'LineStyle','none');
    
    plot([B(1)],[B(2)],'-o',...
                'MarkerEdgeColor',[0 0 0],...
                'MarkerFaceColor',[1 0.1 0.1],...
                'MarkerSize',5.0,...
                'LineStyle','none');


    hold off;
    drawnow;
  