/*
 * Decompiled with CFR 0.152.
 */
package versys.petrinet;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wb.swt.SWTResourceManager;
import versys.dialogs.TransitionPropertiesDialog;
import versys.petrinet.Arc;
import versys.petrinet.CType;
import versys.petrinet.Label;
import versys.petrinet.Node;
import versys.petrinet.PetriNet;

public class Transition
extends Node {
    private Color m_colorEnabled;
    private ArrayList<ArrayList<int[]>> m_arcModes;
    private ArrayList<int[]> m_possibleModes;

    public Transition(int x, int y) {
        this(x, y, null);
    }

    public Transition(int x, int y, String id) {
        this.m_type = CType.CTYPE_TRANS;
        this.m_id = id;
        this.m_x = x;
        this.m_y = y;
        this.m_size = 20;
        this.m_colorEnabled = SWTResourceManager.getColor(50, 180, 50);
    }

    @Override
    public void draw(GC gc) {
        if (this.m_isSimulationRunning && this.isEnabled()) {
            gc.setBackground(this.m_colorEnabled);
        } else if (!this.m_isSimulationRunning && this.m_isSelected) {
            gc.setBackground(s_componentColors[2]);
        } else {
            gc.setBackground(s_componentColors[1]);
        }
        gc.fillRectangle(this.m_x - this.m_size / 2, this.m_y - this.m_size / 2, this.m_size, this.m_size);
        this.m_label.draw(gc);
    }

    @Override
    public void drag(int x, int y) {
        this.m_x = x;
        this.m_y = y;
    }

    @Override
    public boolean checkSelect(int x, int y) {
        if (x < this.m_x - this.m_size / 2) {
            return false;
        }
        if (x > this.m_x + this.m_size / 2) {
            return false;
        }
        if (y < this.m_y - this.m_size / 2) {
            return false;
        }
        return y <= this.m_y + this.m_size / 2;
    }

    public synchronized boolean isEnabled() {
        this.m_arcModes = new ArrayList();
        this.m_possibleModes = new ArrayList();
        if (this.m_inArcs.isEmpty()) {
            return true;
        }
        for (Arc a : this.m_inArcs) {
            ArrayList<int[]> arcModes = a.isFulfilled();
            if (arcModes == null) {
                return false;
            }
            if (!a.hasVariableArcLabelings()) continue;
            this.m_arcModes.add(arcModes);
        }
        if (this.m_arcModes.isEmpty()) {
            return true;
        }
        if (this.m_arcModes.size() > 1) {
            int i = 0;
            while (i < this.m_arcModes.get(0).size()) {
                this.getPossibleModes(0, i, null);
                ++i;
            }
            return !this.m_possibleModes.isEmpty();
        }
        this.m_possibleModes = this.m_arcModes.get(0);
        return true;
    }

    private void getPossibleModes(int i, int j, int[] curMode) {
        if (i == 0) {
            curMode = (int[])this.m_arcModes.get(i).get(j).clone();
        } else {
            int[] mode = this.m_arcModes.get(i).get(j);
            int k = 0;
            while (k < 4) {
                if (curMode[k] < 0) {
                    curMode[k] = mode[k];
                } else if (mode[k] > -1 && curMode[k] != mode[k]) {
                    return;
                }
                ++k;
            }
        }
        if (i == this.m_arcModes.size() - 1) {
            this.m_possibleModes.add((int[])curMode.clone());
        } else {
            int k = 0;
            while (k < this.m_arcModes.get(i + 1).size()) {
                this.getPossibleModes(i + 1, k, (int[])curMode.clone());
                ++k;
            }
        }
    }

    public synchronized void fire() throws Exception {
        int[] mode = null;
        if (!this.m_possibleModes.isEmpty()) {
            mode = (int[])this.m_possibleModes.get((int)(Math.random() * (double)this.m_possibleModes.size())).clone();
            int i = 0;
            while (i < mode.length) {
                int binding;
                do {
                    binding = (int)(Math.random() * (double)PetriNet.TOKEN_NUM_TYPES);
                } while (!this.m_petrinet.getUniverse()[binding]);
                if (mode[i] < 0) {
                    mode[i] = binding;
                }
                ++i;
            }
            System.out.println("Possible Modes:");
            for (int[] dMode : this.m_possibleModes) {
                int i2 = 0;
                while (i2 < dMode.length) {
                    System.out.print(" " + dMode[i2]);
                    ++i2;
                }
                System.out.println();
            }
            System.out.println("Selected mode:");
            int i3 = 0;
            while (i3 < mode.length) {
                System.out.print(" " + mode[i3]);
                ++i3;
            }
            System.out.println();
        } else {
            boolean outVars = false;
            Iterator itOutArcs = this.m_outArcs.iterator();
            while (itOutArcs.hasNext()) {
                if (!((Arc)itOutArcs.next()).hasVariableArcLabelings()) continue;
                outVars = true;
                break;
            }
            if (outVars) {
                mode = new int[PetriNet.TOKEN_NUM_TYPES];
                ArrayList<Integer> bindings = new ArrayList<Integer>();
                int i = 0;
                while (i < PetriNet.TOKEN_NUM_TYPES) {
                    if (this.m_petrinet.getUniverse()[i]) {
                        bindings.add(i);
                    }
                    ++i;
                }
                i = 0;
                while (i < PetriNet.TOKEN_NUM_TYPES) {
                    mode[i] = (Integer)bindings.get((int)(Math.random() * (double)bindings.size()));
                    ++i;
                }
            }
        }
        Iterator itArc = this.m_inArcs.iterator();
        while (itArc.hasNext()) {
            ((Arc)itArc.next()).fire(mode);
        }
        itArc = this.m_outArcs.iterator();
        while (itArc.hasNext()) {
            ((Arc)itArc.next()).fire(mode);
        }
    }

    @Override
    public String toXML() {
        String xml = "<transition id=\"" + this.m_id + "\">\n";
        xml = String.valueOf(xml) + "<graphics>\n<position x=\"" + this.m_x + "\" y=\"" + this.m_y + "\"/>\n" + "</graphics>\n";
        xml = String.valueOf(xml) + this.m_label.toXML();
        xml = String.valueOf(xml) + "</transition>\n";
        return xml;
    }

    @Override
    public boolean openPropertiesDialog(Canvas canvas) {
        TransitionPropertiesDialog dia = new TransitionPropertiesDialog(canvas.getShell(), this);
        return dia.open();
    }

    @Override
    public void removeTokenType(int type) {
    }

    @Override
    public int getSize() {
        return this.m_size + 2;
    }

    @Override
    public Node copy() {
        Transition t = new Transition(this.m_x, this.m_y, this.m_id);
        Label l = new Label(t);
        l.drag(this.m_label.getX() + 5, this.m_label.getY() + 10);
        l.setText(this.m_label.getText());
        return t;
    }
}

