/*
 * Decompiled with CFR 0.152.
 */
package versys.petrinet;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Canvas;
import versys.dialogs.PlacePropertiesDialog;
import versys.petrinet.CType;
import versys.petrinet.Component;
import versys.petrinet.Label;
import versys.petrinet.Node;
import versys.petrinet.PetriNet;

public class Place
extends Node {
    private static final int[][] s_tokenDotPositions = new int[][]{{-5, -5}, {-5, -20}, {-14, 8}, {6, 8}, {-20, -8}, {10, -8}};
    private static final int[][] s_tokenNumberPositions;
    private static final int[] s_positionIndexes;
    private int[] m_iniTokens;
    private int[] m_currTokens;

    static {
        int[][] nArrayArray = new int[36][];
        nArrayArray[0] = new int[]{-10, -8};
        nArrayArray[1] = new int[]{-10, -18};
        nArrayArray[2] = new int[]{-10, 2};
        nArrayArray[3] = new int[]{-10, -22};
        nArrayArray[4] = new int[]{-10, -7};
        nArrayArray[5] = new int[]{-10, 8};
        nArrayArray[6] = new int[]{-10, -22};
        nArrayArray[7] = new int[]{-22, -7};
        int[] nArray = new int[2];
        nArray[1] = -7;
        nArrayArray[8] = nArray;
        nArrayArray[9] = new int[]{-10, 8};
        nArrayArray[10] = new int[]{-10, -26};
        nArrayArray[11] = new int[]{-24, -10};
        nArrayArray[12] = new int[]{2, -10};
        nArrayArray[13] = new int[]{-24, 6};
        nArrayArray[14] = new int[]{2, 6};
        nArrayArray[15] = new int[]{-22, -22};
        nArrayArray[16] = new int[]{2, -22};
        nArrayArray[17] = new int[]{-22, -7};
        nArrayArray[18] = new int[]{2, -7};
        nArrayArray[19] = new int[]{-22, 8};
        nArrayArray[20] = new int[]{2, 8};
        nArrayArray[21] = new int[]{-24, -26};
        nArrayArray[22] = new int[]{2, -26};
        nArrayArray[23] = new int[]{-34, -7};
        nArrayArray[24] = new int[]{-10, -7};
        nArrayArray[25] = new int[]{14, -7};
        nArrayArray[26] = new int[]{-24, 12};
        nArrayArray[27] = new int[]{2, 12};
        nArrayArray[28] = new int[]{-24, -30};
        nArrayArray[29] = new int[]{2, -30};
        nArrayArray[30] = new int[]{-34, -7};
        nArrayArray[31] = new int[]{-10, -15};
        nArrayArray[32] = new int[]{-10, 2};
        nArrayArray[33] = new int[]{14, -7};
        nArrayArray[34] = new int[]{-24, 16};
        nArrayArray[35] = new int[]{2, 16};
        s_tokenNumberPositions = nArrayArray;
        int[] nArray2 = new int[8];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 6;
        nArray2[4] = 10;
        nArray2[5] = 15;
        nArray2[6] = 21;
        nArray2[7] = 28;
        s_positionIndexes = nArray2;
    }

    public Place(int x, int y) {
        this(x, y, null);
    }

    public Place(int x, int y, String id) {
        this.m_type = CType.CTYPE_PLACE;
        this.m_id = id;
        this.m_x = x;
        this.m_y = y;
        this.m_size = 50;
        this.m_iniTokens = new int[PetriNet.TOKEN_NUM_TYPES];
        this.m_currTokens = new int[PetriNet.TOKEN_NUM_TYPES];
    }

    @Override
    public void draw(GC gc) {
        int tokenTypes = 0;
        int tokenAmount = 0;
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            if (this.m_currTokens[i] > 0) {
                ++tokenTypes;
                tokenAmount += this.m_currTokens[i];
            }
            ++i;
        }
        this.m_size = tokenAmount < 7 || tokenTypes < 5 ? 50 : (tokenTypes < 7 ? 65 : 75);
        gc.setLineWidth(2);
        gc.setBackground(s_componentColors[0]);
        if (this.m_isSelected) {
            gc.setForeground(s_componentColors[2]);
        } else {
            gc.setForeground(s_componentColors[1]);
        }
        gc.fillOval(this.m_x - this.m_size / 2, this.m_y - this.m_size / 2, this.m_size, this.m_size);
        gc.drawOval(this.m_x - this.m_size / 2, this.m_y - this.m_size / 2, this.m_size, this.m_size);
        if (tokenAmount < 7) {
            int currToken = 0;
            int i2 = 0;
            while (i2 < PetriNet.TOKEN_NUM_TYPES) {
                gc.setBackground(s_tokenColors[i2]);
                int j = 0;
                while (j < this.m_currTokens[i2]) {
                    gc.fillOval(this.m_x + s_tokenDotPositions[currToken][0], this.m_y + s_tokenDotPositions[currToken][1], 10, 10);
                    ++currToken;
                    ++j;
                }
                ++i2;
            }
        } else {
            int posIndex = s_positionIndexes[tokenTypes - 1];
            int i3 = 0;
            while (i3 < PetriNet.TOKEN_NUM_TYPES) {
                if (this.m_currTokens[i3] > 0) {
                    gc.setForeground(s_tokenColors[i3]);
                    gc.drawString(String.valueOf(this.m_currTokens[i3]), this.m_x + s_tokenNumberPositions[posIndex][0], this.m_y + s_tokenNumberPositions[posIndex][1], true);
                    ++posIndex;
                }
                ++i3;
            }
        }
        this.m_label.draw(gc);
    }

    @Override
    public void drag(int x, int y) {
        this.m_x = x;
        this.m_y = y;
    }

    public void addToken(int num, int type) {
        int n = type;
        this.m_currTokens[n] = this.m_currTokens[n] + num;
    }

    public void removeToken(int num, int type) {
        if (this.m_currTokens[type] < num) {
            return;
        }
        int n = type;
        this.m_currTokens[n] = this.m_currTokens[n] - num;
    }

    public void setTokens(int[] tokens) {
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            this.m_currTokens[i] = tokens[i];
            ++i;
        }
    }

    public boolean isEmpty() {
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            if (this.m_currTokens[i] > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean checkSelect(int x, int y) {
        int dx = x - this.m_x;
        int dy = y - this.m_y;
        return dx * dx + dy * dy <= this.m_size * this.m_size / 4;
    }

    @Override
    public void startSimulation() {
        super.startSimulation();
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            this.m_iniTokens[i] = this.m_currTokens[i];
            ++i;
        }
    }

    @Override
    public void stopSimulation() {
        super.stopSimulation();
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            this.m_currTokens[i] = this.m_iniTokens[i];
            ++i;
        }
    }

    public int[] getTokens() {
        return this.m_currTokens;
    }

    @Override
    public String toXML() {
        String xml = "<place id=\"" + this.m_id + "\">\n";
        xml = String.valueOf(xml) + "<graphics>\n<position x=\"" + this.m_x + "\" y =\"" + this.m_y + "\"/>\n" + "</graphics>\n";
        xml = String.valueOf(xml) + this.m_label.toXML();
        xml = String.valueOf(xml) + "<initialMarking>\n<value>";
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            xml = this.m_isSimulationRunning ? String.valueOf(xml) + new String(Component.s_tokenIDs[i]) + "," + this.m_iniTokens[i] + "," : String.valueOf(xml) + new String(Component.s_tokenIDs[i]) + "," + this.m_currTokens[i] + ",";
            ++i;
        }
        xml = xml.substring(0, xml.length() - 1);
        xml = String.valueOf(xml) + "</value>\n</initialMarking>\n";
        xml = String.valueOf(xml) + "</place>\n";
        return xml;
    }

    @Override
    public boolean openPropertiesDialog(Canvas canvas) {
        PlacePropertiesDialog dia = new PlacePropertiesDialog(canvas.getShell(), this, this.m_petrinet.getUniverse());
        return dia.open();
    }

    @Override
    public void removeTokenType(int type) {
        this.m_currTokens[type] = 0;
    }

    @Override
    public Node copy() {
        Place p = new Place(this.m_x, this.m_y, this.m_id);
        p.setTokens(this.getTokens());
        Label l = new Label(p);
        l.drag(this.m_label.getX() + 5, this.m_label.getY() + 10);
        l.setText(this.m_label.getText());
        return p;
    }
}

