/*
 * Decompiled with CFR 0.152.
 */
package versys.petrinet;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import versys.VersysFile;
import versys.petrinet.Arc;
import versys.petrinet.CType;
import versys.petrinet.Component;
import versys.petrinet.Label;
import versys.petrinet.Node;
import versys.petrinet.PNState;
import versys.petrinet.Place;
import versys.petrinet.Transition;

public class PetriNet {
    public static final int TOKEN_BLACK = 0;
    public static final int TOKEN_NUM_TYPES = Component.s_tokenColors.length;
    public static final int NUM_VARS = 4;
    private boolean[] m_universe;
    private String m_id;
    private int m_numPlaces;
    private ArrayList<Place> m_places;
    private int m_numTransitions;
    private ArrayList<Transition> m_transitions;
    private ArrayList<Arc> m_arcs;
    private ArrayList<Label> m_labels;
    private ArrayList<Component> m_selected;
    private PNState m_state;

    public PetriNet(String id) {
        this.m_id = id;
        this.m_numPlaces = 0;
        this.m_numTransitions = 0;
        this.m_places = new ArrayList();
        this.m_transitions = new ArrayList();
        this.m_arcs = new ArrayList();
        this.m_labels = new ArrayList();
        this.m_selected = new ArrayList();
        this.m_universe = new boolean[TOKEN_NUM_TYPES];
        this.m_universe[0] = true;
        this.m_state = PNState.PN_STATE_EDIT;
    }

    public void draw(GC gc) {
        for (Place p : this.m_places) {
            p.draw(gc);
        }
        for (Transition t : this.m_transitions) {
            t.draw(gc);
        }
        for (Arc a : this.m_arcs) {
            a.draw(gc);
        }
    }

    public void addComponent(Component c, boolean select) {
        switch (c.getType()) {
            case CTYPE_PLACE: {
                if (c.getID() == null) {
                    c.setID("p" + this.m_numPlaces);
                    c.getLabel().setText("p" + this.m_numPlaces++);
                }
                this.m_places.add((Place)c);
                this.m_labels.add(c.getLabel());
                break;
            }
            case CTYPE_TRANS: {
                if (c.getID() == null) {
                    c.setID("t" + this.m_numTransitions);
                    c.getLabel().setText("t" + this.m_numTransitions++);
                }
                this.m_transitions.add((Transition)c);
                this.m_labels.add(c.getLabel());
                break;
            }
            case CTYPE_ARC: {
                boolean arcExists = false;
                Iterator<Arc> ait = this.m_arcs.iterator();
                while (!arcExists && ait.hasNext()) {
                    if (!ait.next().equals((Arc)c)) continue;
                    arcExists = true;
                }
                if (arcExists) {
                    c.delete(this);
                    break;
                }
                this.m_arcs.add((Arc)c);
                this.m_labels.add(c.getLabel());
                break;
            }
            default: {
                c.delete(this);
            }
        }
        c.registerPetriNet(this);
        if (!c.isDeleted() && select) {
            this.m_selected.add(c);
            c.select();
        }
    }

    public void addSubNet(PetriNet subnet) throws Exception {
        VersysFile vf = new VersysFile(subnet);
        vf.parseSubNet(this, true);
    }

    public Arc constructArc(String sourceID, String targetID) {
        Node c;
        Node sourceNode = null;
        Iterator<Place> ip = this.m_places.iterator();
        while (sourceNode == null && ip.hasNext()) {
            Node c2 = ip.next();
            if (!c2.getID().equals(sourceID)) continue;
            sourceNode = c2;
        }
        Iterator<Transition> it = this.m_transitions.iterator();
        while (sourceNode == null && it.hasNext()) {
            Node c3 = it.next();
            if (!c3.getID().equals(sourceID)) continue;
            sourceNode = c3;
        }
        if (sourceNode == null) {
            return null;
        }
        Component targetNode = null;
        ip = this.m_places.iterator();
        while (targetNode == null && ip.hasNext()) {
            c = ip.next();
            if (!c.getID().equals(targetID)) continue;
            targetNode = c;
        }
        it = this.m_transitions.iterator();
        while (targetNode == null && it.hasNext()) {
            c = it.next();
            if (!c.getID().equals(targetID)) continue;
            targetNode = c;
        }
        if (targetNode == null || sourceNode.getType() == targetNode.getType()) {
            return null;
        }
        return new Arc(sourceNode, (Node)targetNode);
    }

    public Component checkSelect(int x, int y) {
        Transition t;
        int i;
        if (this.m_state != PNState.PN_STATE_EDIT) {
            i = this.m_transitions.size() - 1;
            while (i >= 0) {
                t = this.m_transitions.get(i);
                if (t.checkSelect(x, y)) {
                    return t;
                }
                --i;
            }
        }
        i = this.m_labels.size() - 1;
        while (i >= 0) {
            Label l = this.m_labels.get(i);
            if (l.checkSelect(x, y)) {
                return l;
            }
            --i;
        }
        i = this.m_places.size() - 1;
        while (i >= 0) {
            Place p = this.m_places.get(i);
            if (p.checkSelect(x, y)) {
                return p;
            }
            --i;
        }
        if (this.m_state == PNState.PN_STATE_EDIT) {
            i = this.m_transitions.size() - 1;
            while (i >= 0) {
                t = this.m_transitions.get(i);
                if (t.checkSelect(x, y)) {
                    return t;
                }
                --i;
            }
        }
        i = this.m_arcs.size() - 1;
        while (i >= 0) {
            Arc a = this.m_arcs.get(i);
            if (a.checkSelect(x, y)) {
                return a;
            }
            --i;
        }
        return null;
    }

    public boolean selectComponent(int x, int y) {
        Component c = this.checkSelect(x, y);
        if (c != null) {
            this.m_selected.add(c);
            return true;
        }
        return false;
    }

    public void selectComponents(Rectangle r) {
        for (Label l : this.m_labels) {
            if (!l.checkSelect(r) || l.isSelected()) continue;
            l.select();
            this.m_selected.add(l);
        }
        for (Place p : this.m_places) {
            if (!p.checkSelect(r) || p.isSelected()) continue;
            p.select();
            this.m_selected.add(p);
        }
        for (Transition t : this.m_transitions) {
            if (!t.checkSelect(r) || t.isSelected()) continue;
            t.select();
            this.m_selected.add(t);
        }
        for (Arc a : this.m_arcs) {
            if (!a.checkSelect(r) || a.isSelected()) continue;
            a.select();
            this.m_selected.add(a);
        }
    }

    public void toggleSelection(Component c) {
        if (this.m_selected.contains(c)) {
            this.m_selected.remove(c);
            c.unselect();
        } else {
            this.m_selected.add(c);
            c.select();
        }
    }

    public boolean hasSelected() {
        return this.m_selected.size() > 0;
    }

    public ArrayList<Component> getSelected() {
        return this.m_selected;
    }

    public void unselect() {
        for (Component c : this.m_selected) {
            c.unselect();
        }
        this.m_selected.clear();
    }

    public boolean deleteSelected() {
        boolean change = this.m_selected.size() > 0;
        for (Component c : this.m_selected) {
            if (c.isDeleted()) continue;
            this.deleteComponent(c);
        }
        this.unselect();
        return change;
    }

    public PetriNet copySelected() {
        if (this.m_selected.isEmpty()) {
            return null;
        }
        PetriNet copy = new PetriNet(String.valueOf(this.m_id) + ".selection_copy");
        for (Component c : this.m_selected) {
            if (c.getType() != CType.CTYPE_PLACE && c.getType() != CType.CTYPE_TRANS) continue;
            copy.addComponent(((Node)c).copy(), false);
        }
        for (Component c : this.m_selected) {
            Arc a;
            if (c.getType() != CType.CTYPE_ARC || (a = ((Arc)c).copy(copy)) == null) continue;
            copy.addComponent(a, false);
        }
        return copy;
    }

    public void deleteComponent(Component c) {
        if (c == null) {
            return;
        }
        this.m_places.remove(c);
        this.m_transitions.remove(c);
        this.m_arcs.remove(c);
        c.delete(this);
    }

    public void dragSelected(int x, int y, Component dragReference) {
        switch (this.m_selected.size()) {
            case 0: {
                return;
            }
            case 1: {
                this.m_selected.get(0).drag(x, y);
                break;
            }
            default: {
                int refX = dragReference.getX();
                int refY = dragReference.getY();
                for (Component c : this.m_selected) {
                    if (c.getType() == CType.CTYPE_LABEL || c.getType() == CType.CTYPE_ARC && !((Arc)c).isCurved()) continue;
                    int dx = c.getX() - refX;
                    int dy = c.getY() - refY;
                    c.drag(x + dx, y + dy);
                }
            }
        }
    }

    public void translate(int tx, int ty) {
        for (Place p : this.m_places) {
            p.drag(p.getX() + tx, p.getY() + ty);
        }
        for (Transition t : this.m_transitions) {
            t.drag(t.getX() + tx, t.getY() + ty);
        }
        for (Arc a : this.m_arcs) {
            if (!a.isCurved()) continue;
            a.drag(a.getX() + tx, a.getY() + ty);
        }
    }

    public Point getCenter() {
        Node n0;
        Point ul = new Point(0, 0);
        Point lr = new Point(0, 0);
        if (!this.m_places.isEmpty()) {
            n0 = this.m_places.get(0);
        } else if (!this.m_transitions.isEmpty()) {
            n0 = this.m_transitions.get(0);
        } else {
            return null;
        }
        ul.x = lr.x = n0.getX();
        ul.y = lr.y = n0.getY();
        for (Place p : this.m_places) {
            if (p.getX() > lr.x) {
                lr.x = p.getX();
            }
            if (p.getX() < ul.x) {
                ul.x = p.getX();
            }
            if (p.getY() > lr.y) {
                lr.y = p.getY();
            }
            if (p.getY() >= ul.y) continue;
            ul.y = p.getY();
        }
        for (Transition t : this.m_transitions) {
            if (t.getX() > lr.x) {
                lr.x = t.getX();
            }
            if (t.getX() < ul.x) {
                ul.x = t.getX();
            }
            if (t.getY() > lr.y) {
                lr.y = t.getY();
            }
            if (t.getY() >= ul.y) continue;
            ul.y = t.getY();
        }
        int cx = (lr.x - ul.x) / 2 + ul.x;
        int cy = (lr.y - ul.y) / 2 + ul.y;
        return new Point(cx, cy);
    }

    public void setUniverse(boolean[] u) {
        int i = 0;
        while (i < TOKEN_NUM_TYPES) {
            if (this.m_universe[i] && !u[i]) {
                Iterator<Place> pit = this.m_places.iterator();
                while (pit.hasNext()) {
                    pit.next().removeTokenType(i);
                }
                Iterator<Arc> ait = this.m_arcs.iterator();
                while (ait.hasNext()) {
                    ait.next().removeTokenType(i);
                }
            }
            this.m_universe[i] = u[i];
            ++i;
        }
    }

    public boolean[] getUniverse() {
        return this.m_universe;
    }

    public void startSimulation() {
        this.unselect();
        for (Place p : this.m_places) {
            p.startSimulation();
        }
        for (Transition t : this.m_transitions) {
            t.startSimulation();
        }
        for (Arc a : this.m_arcs) {
            a.startSimulation();
        }
        this.m_state = PNState.PN_STATE_MANUAL_SIM;
    }

    public void stopSimulation() {
        if (this.m_state == PNState.PN_STATE_AUTO_SIM) {
            this.stopAutoSimulation();
        }
        Iterator<Place> pit = this.m_places.iterator();
        while (pit.hasNext()) {
            pit.next().stopSimulation();
        }
        Iterator<Transition> tit = this.m_transitions.iterator();
        while (tit.hasNext()) {
            tit.next().stopSimulation();
        }
        Iterator<Arc> ait = this.m_arcs.iterator();
        while (ait.hasNext()) {
            ait.next().stopSimulation();
        }
        this.m_state = PNState.PN_STATE_EDIT;
    }

    public void startAutoSimulation() {
        this.unselect();
        this.m_state = PNState.PN_STATE_AUTO_SIM;
    }

    public void stopAutoSimulation() {
        this.m_state = PNState.PN_STATE_MANUAL_SIM;
    }

    public PNState getState() {
        return this.m_state;
    }

    public String fireRandomTransition() throws Exception {
        if (this.m_state != PNState.PN_STATE_AUTO_SIM) {
            return null;
        }
        ArrayList<Transition> enabledT = new ArrayList<Transition>();
        for (Transition t : this.m_transitions) {
            if (!t.isEnabled()) continue;
            enabledT.add(t);
        }
        int numT = enabledT.size();
        if (numT == 0) {
            return null;
        }
        int ran = (int)(Math.random() * (double)numT);
        ((Transition)enabledT.get(ran)).fire();
        return ((Transition)enabledT.get(ran)).getLabel().getText();
    }

    public String toXML() {
        String xml = "<net id=\"" + this.m_id + "\" type=\"P/T net\">\n";
        int i = 0;
        while (i < TOKEN_NUM_TYPES) {
            xml = String.valueOf(xml) + this.getXMLTokenDef(i, Component.s_tokenColors[i]);
            ++i;
        }
        Iterator<Place> ip = this.m_places.iterator();
        while (ip.hasNext()) {
            xml = String.valueOf(xml) + ip.next().toXML();
        }
        Iterator<Transition> it = this.m_transitions.iterator();
        while (it.hasNext()) {
            xml = String.valueOf(xml) + it.next().toXML();
        }
        Iterator<Arc> ia = this.m_arcs.iterator();
        while (ia.hasNext()) {
            xml = String.valueOf(xml) + ia.next().toXML();
        }
        xml = String.valueOf(xml) + "</net>\n";
        return xml;
    }

    public String getID() {
        return this.m_id;
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public void serializeComponentIDs() {
        this.m_numPlaces = 0;
        Iterator<Place> ip = this.m_places.iterator();
        while (ip.hasNext()) {
            ip.next().setID("p" + this.m_numPlaces++);
        }
        this.m_numTransitions = 0;
        Iterator<Transition> it = this.m_transitions.iterator();
        while (it.hasNext()) {
            it.next().setID("t" + this.m_numTransitions++);
        }
        Iterator<Arc> ia = this.m_arcs.iterator();
        while (ia.hasNext()) {
            ia.next().updateID();
        }
    }

    private String getXMLTokenDef(int id, Color color) {
        int r = color.getRed();
        int g = color.getGreen();
        int b = color.getBlue();
        return "<token id=\"" + new String(Component.s_tokenIDs[id]) + "\" enabled=\"" + this.m_universe[id] + "\" " + "red=\"" + r + "\" " + "green=\"" + g + "\" " + "blue=\"" + b + "\"/>\n";
    }

    public PetriNet copy() throws Exception {
        PetriNet copy = null;
        VersysFile vf = new VersysFile(this);
        copy = vf.parsePetriNet();
        copy.serializeComponentIDs();
        return copy;
    }
}

