/*
 * Decompiled with CFR 0.152.
 */
package versys.petrinet;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Rectangle;
import versys.petrinet.Arc;
import versys.petrinet.Component;
import versys.petrinet.PetriNet;

public abstract class Node
extends Component {
    protected int m_size;
    protected ArrayList<Arc> m_inArcs = new ArrayList();
    protected ArrayList<Arc> m_outArcs = new ArrayList();

    @Override
    public void delete(PetriNet pn) {
        this.m_isDeleted = true;
        Iterator<Arc> itArc = this.m_inArcs.iterator();
        while (itArc.hasNext()) {
            pn.deleteComponent(itArc.next());
        }
        itArc = this.m_outArcs.iterator();
        while (itArc.hasNext()) {
            pn.deleteComponent(itArc.next());
        }
    }

    public void addInArc(Arc arc) {
        this.m_inArcs.add(arc);
    }

    public void addOutArc(Arc arc) {
        this.m_outArcs.add(arc);
    }

    public void removeInArc(Arc arc) {
        this.m_inArcs.remove(arc);
    }

    public void removeOutArc(Arc arc) {
        this.m_outArcs.remove(arc);
    }

    public int getSize() {
        return this.m_size;
    }

    public void setLabelVisible(boolean labelVisible) {
        this.m_label.setVisible(labelVisible);
    }

    public boolean isLabelVisible() {
        return this.m_label.isVisible();
    }

    @Override
    public boolean checkSelect(Rectangle r) {
        return r.contains(this.m_x, this.m_y);
    }

    public abstract Node copy();
}

