/*
 * Decompiled with CFR 0.152.
 */
package versys.petrinet;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import versys.EditorTab;
import versys.petrinet.Arc;
import versys.petrinet.CType;
import versys.petrinet.Component;
import versys.petrinet.PetriNet;

public class Label
extends Component {
    private static final PaletteData s_paletteData = new PaletteData(new RGB[]{s_componentColors[0].getRGB(), s_tokenColors[0].getRGB(), s_tokenColors[1].getRGB(), s_tokenColors[2].getRGB(), s_tokenColors[3].getRGB(), s_tokenColors[4].getRGB(), s_tokenColors[5].getRGB(), s_tokenColors[6].getRGB(), s_tokenColors[7].getRGB()});
    private Component m_component;
    private String m_text;
    private Image m_image;
    private boolean m_isVisible;
    private boolean m_isDrawn;

    public Label(Component c) {
        this.m_type = CType.CTYPE_LABEL;
        this.m_component = c;
        c.setLabel(this);
        switch (c.getType()) {
            case CTYPE_PLACE: {
                this.m_x = -25;
                this.m_y = 30;
                this.m_text = c.getID();
                break;
            }
            case CTYPE_TRANS: {
                this.m_x = -10;
                this.m_y = 15;
                this.m_text = c.getID();
                break;
            }
            case CTYPE_ARC: {
                this.m_x = 0;
                this.m_y = 10;
                this.m_text = "";
            }
        }
        this.m_isVisible = true;
        this.m_isDrawn = true;
    }

    @Override
    public void draw(GC gc) {
        if (!this.m_isVisible) {
            return;
        }
        if (this.m_component.getType() != CType.CTYPE_ARC) {
            if (this.m_isSelected) {
                gc.setForeground(s_componentColors[2]);
            } else {
                gc.setForeground(s_componentColors[1]);
            }
            gc.drawString(this.m_text, this.m_component.getX() + this.m_x, this.m_component.getY() + this.m_y, true);
        } else {
            int[] weights = ((Arc)this.m_component).getArcWeights();
            int numWeights = 1;
            int largestWeight = 1;
            this.m_isDrawn = false;
            if (weights[0] > 1) {
                this.m_isDrawn = true;
                largestWeight = weights[0];
            }
            int i = 1;
            while (i < PetriNet.TOKEN_NUM_TYPES + 4) {
                if (weights[i] > 0) {
                    this.m_isDrawn = true;
                    ++numWeights;
                    if (weights[i] > largestWeight) {
                        largestWeight = weights[i];
                    }
                }
                ++i;
            }
            if (this.m_isDrawn) {
                String factor;
                int offset;
                int labelWidth = String.valueOf(largestWeight).length() * 10 + 20;
                int fontHeight = (int)gc.getFont().getFontData()[0].height;
                int labelHeight = numWeights * (fontHeight + 3);
                if (this.m_image != null) {
                    this.m_image.dispose();
                }
                ImageData id = new ImageData(labelWidth, labelHeight, 4, s_paletteData);
                id.transparentPixel = 0;
                this.m_image = new Image(gc.getDevice(), id);
                GC gci = new GC((Drawable)this.m_image);
                gci.setBackground(s_componentColors[0]);
                gci.fillRectangle(0, 0, labelWidth, labelHeight);
                int y = 0;
                int i2 = 0;
                while (i2 < PetriNet.TOKEN_NUM_TYPES) {
                    if (weights[i2] > 0) {
                        offset = 0;
                        if (weights[i2] > 1) {
                            factor = String.valueOf(weights[i2]);
                            gci.drawString(factor, 0, y, true);
                            offset = factor.length() * 9;
                        }
                        gci.setBackground(s_tokenColors[i2]);
                        gci.fillOval(offset, y + 2, 10, 10);
                        y += fontHeight + 3;
                    }
                    ++i2;
                }
                gci.setBackground(s_componentColors[0]);
                i2 = PetriNet.TOKEN_NUM_TYPES;
                while (i2 < PetriNet.TOKEN_NUM_TYPES + 4) {
                    if (weights[i2] > 0) {
                        offset = 0;
                        if (weights[i2] > 1) {
                            factor = String.valueOf(weights[i2]);
                            gci.drawString(factor, 0, y);
                            offset = factor.length() * 9;
                        }
                        gci.drawString(new String(s_tokenIDs[i2]), offset, y);
                        y += fontHeight + 3;
                    }
                    ++i2;
                }
                gci.dispose();
                int lx = this.m_component.getX() + this.m_x;
                int ly = this.m_component.getY() + this.m_y;
                gc.drawImage(this.m_image, lx, ly);
            }
        }
    }

    @Override
    public boolean checkSelect(int x, int y) {
        if (!this.m_isVisible || !this.m_isDrawn) {
            return false;
        }
        if (this.m_component.getType() == CType.CTYPE_ARC) {
            Rectangle rect = this.m_image.getBounds();
            rect.x = this.m_component.getX() + this.m_x;
            rect.y = this.m_component.getY() + this.m_y;
            return rect.contains(x, y);
        }
        Path p = new Path((Device)Display.getCurrent());
        p.addString(this.m_text, (float)(this.m_component.getX() + this.m_x), (float)(this.m_component.getY() + this.m_y), EditorTab.CANVAS_FONT);
        float[] bounds = new float[4];
        p.getBounds(bounds);
        p.dispose();
        if (bounds[2] == 0.0f) {
            bounds[2] = EditorTab.CANVAS_FONT.getFontData()[0].getHeight() * this.m_text.length();
        }
        if (bounds[3] == 0.0f) {
            bounds[3] = EditorTab.CANVAS_FONT.getFontData()[0].getHeight();
        }
        System.out.println("x: " + bounds[0]);
        System.out.println("y: " + bounds[1]);
        System.out.println("w: " + bounds[2]);
        System.out.println("h: " + bounds[3]);
        System.out.println("(" + x + ", " + y + ")");
        if ((float)x < bounds[0]) {
            return false;
        }
        if ((float)y < bounds[1]) {
            return false;
        }
        if ((float)x > bounds[0] + bounds[2]) {
            return false;
        }
        return !((float)y > bounds[1] + bounds[3]);
    }

    @Override
    public boolean checkSelect(Rectangle r) {
        if (!this.m_isVisible || !this.m_isDrawn) {
            return false;
        }
        if (this.m_component.getType() == CType.CTYPE_ARC) {
            Rectangle rect = this.m_image.getBounds();
            rect.x = this.m_component.getX() + this.m_x;
            rect.y = this.m_component.getY() + this.m_y;
            return r.intersects(rect);
        }
        Path p = new Path((Device)Display.getCurrent());
        p.addString(this.m_text, (float)(this.m_component.getX() + this.m_x), (float)(this.m_component.getY() + this.m_y), EditorTab.CANVAS_FONT);
        float[] bounds = new float[4];
        p.getBounds(bounds);
        p.dispose();
        Rectangle rect = new Rectangle((int)bounds[0], (int)bounds[1], (int)bounds[2], (int)bounds[3]);
        return r.intersects(rect);
    }

    @Override
    public int getX() {
        return this.m_component.getX() + this.m_x;
    }

    @Override
    public int getY() {
        return this.m_component.getY() + this.m_y;
    }

    @Override
    public void drag(int x, int y) {
        this.m_x = x - this.m_component.getX() - 5;
        this.m_y = y - this.m_component.getY() - 10;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public String getText() {
        return this.m_text;
    }

    public void setVisible(boolean visible) {
        this.m_isVisible = visible;
    }

    public boolean isVisible() {
        return this.m_isVisible;
    }

    @Override
    public boolean openPropertiesDialog(Canvas canvas) {
        return this.m_component.openPropertiesDialog(canvas);
    }

    @Override
    public String toXML() {
        String xml = "<name visible=\"" + this.m_isVisible + "\">\n";
        xml = String.valueOf(xml) + "<value>" + this.m_text + "</value>\n";
        xml = String.valueOf(xml) + "<graphics>\n<offset x=\"" + this.m_x + "\" y=\"" + this.m_y + "\"/>\n" + "</graphics>";
        xml = String.valueOf(xml) + "</name>\n";
        return xml;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.m_image != null) {
                this.m_image.dispose();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void resetID() {
    }

    @Override
    public void removeTokenType(int type) {
    }

    @Override
    public void delete(PetriNet pn) {
    }
}

