/*
 * Decompiled with CFR 0.152.
 */
package versys.petrinet;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wb.swt.SWTResourceManager;
import versys.petrinet.CType;
import versys.petrinet.Label;
import versys.petrinet.PetriNet;

public abstract class Component {
    protected static final Color[] s_componentColors = new Color[]{SWTResourceManager.getColor(255, 255, 255), SWTResourceManager.getColor(0, 0, 0), SWTResourceManager.getColor(150, 200, 255)};
    public static final Color[] s_tokenColors = new Color[]{SWTResourceManager.getColor(0, 0, 0), SWTResourceManager.getColor(255, 0, 0), SWTResourceManager.getColor(0, 200, 0), SWTResourceManager.getColor(80, 80, 255), SWTResourceManager.getColor(255, 150, 0), SWTResourceManager.getColor(110, 75, 0), SWTResourceManager.getColor(140, 50, 255), SWTResourceManager.getColor(120, 240, 240)};
    public static final PaletteData s_paletteData = new PaletteData(new RGB[]{s_tokenColors[0].getRGB(), s_tokenColors[1].getRGB(), s_tokenColors[2].getRGB(), s_tokenColors[3].getRGB(), s_tokenColors[4].getRGB(), s_tokenColors[5].getRGB(), s_tokenColors[6].getRGB(), s_tokenColors[7].getRGB()});
    public static String[] s_tokenIDs = new String[]{"Schwarz", "Rot", "Gr\u00fcn", "Blau", "Orange", "Braun", "Violett", "Cyan", "X", "Y", "A", "B", "U", "V", "S", "T"};
    protected int m_x;
    protected int m_y;
    protected boolean m_isSelected;
    protected boolean m_isDeleted = false;
    protected CType m_type;
    protected String m_id;
    protected PetriNet m_petrinet;
    protected boolean m_isSimulationRunning = false;
    protected Label m_label;

    public CType getType() {
        return this.m_type;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public void select() {
        this.m_isSelected = true;
    }

    public boolean isSelected() {
        return this.m_isSelected;
    }

    public void unselect() {
        this.m_isSelected = false;
    }

    public void startSimulation() {
        this.m_isSimulationRunning = true;
    }

    public void stopSimulation() {
        this.m_isSimulationRunning = false;
    }

    public void setLabel(Label l) {
        this.m_label = l;
    }

    public Label getLabel() {
        return this.m_label;
    }

    public boolean isDeleted() {
        return this.m_isDeleted;
    }

    public String getID() {
        return this.m_id;
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public void registerPetriNet(PetriNet net) {
        this.m_petrinet = net;
    }

    public abstract String toXML();

    public abstract void draw(GC var1);

    public abstract void drag(int var1, int var2);

    public abstract boolean checkSelect(int var1, int var2);

    public abstract boolean checkSelect(Rectangle var1);

    public abstract boolean openPropertiesDialog(Canvas var1);

    public abstract void removeTokenType(int var1);

    public abstract void delete(PetriNet var1);
}

