/*
 * Decompiled with CFR 0.152.
 */
package versys.petrinet;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import versys.dialogs.ArcPropertiesDialog;
import versys.petrinet.CType;
import versys.petrinet.Component;
import versys.petrinet.Label;
import versys.petrinet.Node;
import versys.petrinet.PetriNet;
import versys.petrinet.Place;

public class Arc
extends Component {
    private static final double s_cosa1 = Math.cos(0.4);
    private static final double s_sina1 = Math.sin(0.4);
    private static final double s_cosa2 = Math.cos(-0.4);
    private static final double s_sina2 = Math.sin(-0.4);
    private Node m_source;
    private Node m_target;
    private PathData m_pathData;
    private int m_numPoints;
    private int[] m_arcWeights;
    private int m_numVars;
    private int[] m_vars;

    public Arc(Node source, Node target) {
        this.m_type = CType.CTYPE_ARC;
        this.m_source = source;
        this.m_target = target;
        this.m_source.addOutArc(this);
        this.m_target.addInArc(this);
        this.m_id = String.valueOf(this.m_source.getID()) + " to " + this.m_target.getID();
        this.m_numPoints = 2;
        this.m_pathData = new PathData();
        this.m_pathData.points = new float[2 * this.m_numPoints];
        this.m_pathData.types = new byte[this.m_numPoints];
        this.m_pathData.types[0] = 1;
        this.m_pathData.types[1] = 2;
        this.m_arcWeights = new int[PetriNet.TOKEN_NUM_TYPES + 4];
        this.m_arcWeights[0] = 1;
        this.m_numVars = 0;
        this.updatePosition();
    }

    @Override
    public void draw(GC gc) {
        int x1 = this.m_source.getX();
        int y1 = this.m_source.getY();
        int x2 = this.m_target.getX();
        int y2 = this.m_target.getY();
        float cut1 = (float)this.m_source.getSize() / 2.0f;
        float cut2 = (float)this.m_target.getSize() / 2.0f;
        if (this.m_numPoints == 2) {
            int[] arc = this.getEndpoints(x1, y1, x2, y2, cut1, cut2);
            int i = 0;
            while (i < this.m_numPoints * 2) {
                this.m_pathData.points[i] = arc[i];
                ++i;
            }
        } else {
            int[] arcSec1 = this.getEndpoints(x1, y1, this.m_pathData.points[2], this.m_pathData.points[3], cut1, 0.0f);
            int[] arcSec2 = this.getEndpoints(this.m_pathData.points[4], this.m_pathData.points[5], x2, y2, 0.0f, cut2);
            this.m_pathData.points[0] = arcSec1[0];
            this.m_pathData.points[1] = arcSec1[1];
            this.m_pathData.points[6] = arcSec2[2];
            this.m_pathData.points[7] = arcSec2[3];
        }
        Path path = new Path(gc.getDevice(), this.m_pathData);
        gc.setLineWidth(2);
        if (this.isSelected()) {
            gc.setForeground(s_componentColors[2]);
        } else {
            gc.setForeground(s_componentColors[1]);
        }
        gc.drawPath(path);
        int[] arcHead = this.getArcHead(this.m_pathData.points[2 * this.m_numPoints - 4], this.m_pathData.points[2 * this.m_numPoints - 3], this.m_pathData.points[2 * this.m_numPoints - 2], this.m_pathData.points[2 * this.m_numPoints - 1]);
        if (this.isSelected()) {
            gc.setBackground(s_componentColors[2]);
        } else {
            gc.setBackground(s_componentColors[1]);
        }
        gc.fillPolygon(arcHead);
        path.dispose();
        this.updatePosition();
        this.m_label.draw(gc);
    }

    @Override
    public void drag(int x, int y) {
        if (this.m_numPoints == 2) {
            this.m_numPoints = 4;
            float[] newPoints = new float[2 * this.m_numPoints];
            newPoints[0] = this.m_pathData.points[0];
            newPoints[1] = this.m_pathData.points[1];
            newPoints[6] = this.m_pathData.points[2];
            newPoints[7] = this.m_pathData.points[3];
            this.m_pathData.points = newPoints;
            this.m_pathData.types[1] = 4;
        }
        this.m_pathData.points[2] = x;
        this.m_pathData.points[3] = y;
        this.m_pathData.points[4] = x;
        this.m_pathData.points[5] = y;
        this.updatePosition();
    }

    public boolean isCurved() {
        return this.m_numPoints > 2;
    }

    public void resetCurve() {
        if (!this.isCurved()) {
            return;
        }
        this.m_numPoints = 2;
        float[] newPoints = new float[2 * this.m_numPoints];
        newPoints[0] = this.m_pathData.points[0];
        newPoints[1] = this.m_pathData.points[1];
        newPoints[2] = this.m_pathData.points[6];
        newPoints[3] = this.m_pathData.points[7];
        this.m_pathData.points = newPoints;
        this.m_pathData.types[1] = 2;
    }

    @Override
    public boolean checkSelect(int x, int y) {
        if (this.m_numPoints == 2) {
            double v1m;
            double projection;
            double v1x = this.m_target.getX() - this.m_source.getX();
            double v1y = this.m_target.getY() - this.m_source.getY();
            double v2x = x - this.m_source.getX();
            double v2y = y - this.m_source.getY();
            if ((projection = (v1x /= (v1m = Math.sqrt(v1x * v1x + v1y * v1y))) * v2x + (v1y /= v1m) * v2y) < 0.0 || projection > v1m) {
                return false;
            }
            double dx = (v1x *= projection) - v2x;
            double dy = (v1y *= projection) - v2y;
            double dist = Math.sqrt(dx * dx + dy * dy);
            return dist < 3.0;
        }
        Path path = new Path((Device)Display.getDefault(), this.m_pathData);
        GC gc = new GC((Drawable)Display.getDefault());
        boolean selected = false;
        float ix = (float)x - 3.0f;
        while (ix <= (float)x + 3.0f && !selected) {
            float iy = (float)y - 3.0f;
            while (iy <= (float)y + 3.0f && !selected) {
                selected = path.contains(ix, iy, gc, true);
                iy += 0.1f;
            }
            ix += 0.1f;
        }
        path.dispose();
        gc.dispose();
        return selected;
    }

    @Override
    public boolean checkSelect(Rectangle r) {
        if (this.m_numPoints == 2) {
            return this.m_source.isSelected() && this.m_target.isSelected();
        }
        return (this.m_source.isSelected() || this.m_target.isSelected()) && r.contains((int)this.m_pathData.points[2], (int)this.m_pathData.points[3]);
    }

    public boolean hasVariableArcLabelings() {
        return this.m_numVars > 0;
    }

    public ArrayList<int[]> isFulfilled() {
        if (this.m_source.getType() != CType.CTYPE_PLACE) {
            return null;
        }
        int[] sourceTokens = (int[])((Place)this.m_source).getTokens().clone();
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            int n = i;
            sourceTokens[n] = sourceTokens[n] - this.m_arcWeights[i];
            if (sourceTokens[i] < 0) {
                return null;
            }
            ++i;
        }
        if (!this.hasVariableArcLabelings()) {
            return new ArrayList<int[]>();
        }
        return this.getArcModes(sourceTokens);
    }

    private ArrayList<int[]> getArcModes(int[] sourceTokens) {
        int j;
        String fullSet = "";
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            if (this.m_petrinet.getUniverse()[i]) {
                fullSet = String.valueOf(fullSet) + String.valueOf(i);
            }
            ++i;
        }
        String[] possibleBindings = new String[this.m_numVars];
        int i2 = 0;
        while (i2 < this.m_numVars) {
            possibleBindings[i2] = fullSet;
            ++i2;
        }
        i2 = 0;
        while (i2 < this.m_numVars) {
            int j2 = 0;
            while (j2 < PetriNet.TOKEN_NUM_TYPES) {
                if (this.m_arcWeights[this.m_vars[i2]] > sourceTokens[j2]) {
                    String s = Character.toString((char)(j2 + 48));
                    possibleBindings[i2] = possibleBindings[i2].replace(s, "");
                    if (possibleBindings[i2].length() < 1) {
                        return null;
                    }
                }
                ++j2;
            }
            ++i2;
        }
        boolean changed = false;
        do {
            changed = false;
            int i3 = 0;
            while (i3 < this.m_numVars) {
                if (possibleBindings[i3].length() == 1) {
                    int ident = Integer.parseInt(possibleBindings[i3]);
                    int remains = sourceTokens[ident] - this.m_arcWeights[this.m_vars[i3]];
                    j = 0;
                    while (j < this.m_numVars) {
                        if (j != i3 && possibleBindings[j].contains(possibleBindings[i3]) && this.m_arcWeights[this.m_vars[j]] > remains) {
                            possibleBindings[j] = possibleBindings[j].replace(possibleBindings[i3], "");
                            if (possibleBindings[j].length() < 1) {
                                return null;
                            }
                            changed = true;
                        }
                        ++j;
                    }
                }
                ++i3;
            }
        } while (changed);
        ArrayList<int[]> modeList = new ArrayList<int[]>();
        int i4 = 0;
        while (i4 < possibleBindings[0].length()) {
            int[] mode = new int[4];
            j = 0;
            while (j < mode.length) {
                mode[j] = -1;
                ++j;
            }
            this.getVarBindings(possibleBindings, modeList, 0, i4, mode, sourceTokens);
            ++i4;
        }
        if (modeList.isEmpty()) {
            return null;
        }
        return modeList;
    }

    private void getVarBindings(String[] possibleBinds, ArrayList<int[]> modeList, int curVar, int curBind, int[] curMode, int[] sourceTokens) {
        int bind = Integer.parseInt(possibleBinds[curVar].substring(curBind, curBind + 1));
        int remains = sourceTokens[bind];
        int i = 0;
        while (i < curVar) {
            if (curMode[this.m_vars[i] - PetriNet.TOKEN_NUM_TYPES] == bind && (remains -= this.m_arcWeights[this.m_vars[i]]) < this.m_arcWeights[this.m_vars[curVar]]) {
                return;
            }
            ++i;
        }
        curMode[this.m_vars[curVar] - PetriNet.TOKEN_NUM_TYPES] = bind;
        if (curVar == this.m_numVars - 1) {
            modeList.add((int[])curMode.clone());
        } else {
            int k = 0;
            while (k < possibleBinds[curVar + 1].length()) {
                this.getVarBindings(possibleBinds, modeList, curVar + 1, k, curMode, sourceTokens);
                ++k;
            }
        }
    }

    public void fire(int[] mode) throws Exception {
        block7: {
            block6: {
                if (mode == null && this.hasVariableArcLabelings()) {
                    throw new Exception("Arc '" + this.getID() + "' has variable arc labelings, but mode is null.");
                }
                if (this.m_source.getType() != CType.CTYPE_PLACE) break block6;
                int i = 0;
                while (i < PetriNet.TOKEN_NUM_TYPES) {
                    ((Place)this.m_source).removeToken(this.m_arcWeights[i], i);
                    ++i;
                }
                if (mode == null) break block7;
                i = 0;
                while (i < 4) {
                    ((Place)this.m_source).removeToken(this.m_arcWeights[i + PetriNet.TOKEN_NUM_TYPES], mode[i]);
                    ++i;
                }
                break block7;
            }
            int i = 0;
            while (i < PetriNet.TOKEN_NUM_TYPES) {
                ((Place)this.m_target).addToken(this.m_arcWeights[i], i);
                ++i;
            }
            if (mode != null) {
                i = 0;
                while (i < 4) {
                    ((Place)this.m_target).addToken(this.m_arcWeights[i + PetriNet.TOKEN_NUM_TYPES], mode[i]);
                    ++i;
                }
            }
        }
    }

    public int[] getArcWeights() {
        return this.m_arcWeights;
    }

    public void setArcWeights(int[] weights) {
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES + 4) {
            this.m_arcWeights[i] = weights[i];
            ++i;
        }
        this.m_numVars = 0;
        i = PetriNet.TOKEN_NUM_TYPES;
        while (i < PetriNet.TOKEN_NUM_TYPES + 4) {
            if (this.m_arcWeights[i] > 0) {
                ++this.m_numVars;
            }
            ++i;
        }
        this.m_vars = new int[this.m_numVars];
        int curVar = 0;
        int i2 = PetriNet.TOKEN_NUM_TYPES;
        while (i2 < PetriNet.TOKEN_NUM_TYPES + 4) {
            if (this.m_arcWeights[i2] > 0) {
                this.m_vars[curVar++] = i2;
            }
            ++i2;
        }
    }

    public Component getSource() {
        return this.m_source;
    }

    public Component getTarget() {
        return this.m_target;
    }

    public boolean equals(Arc a) {
        return a.getSource() == this.m_source && a.getTarget() == this.m_target;
    }

    private int[] getEndpoints(float x1, float y1, float x2, float y2, float cut1, float cut2) {
        int[] endPoint = new int[4];
        float dx = x1 - x2;
        float dy = y1 - y2;
        double dist = Math.sqrt(dx * dx + dy * dy);
        double nx = (double)dx / dist;
        double ny = (double)dy / dist;
        endPoint[0] = (int)((double)x1 - nx * (double)cut1);
        endPoint[1] = (int)((double)y1 - ny * (double)cut1);
        endPoint[2] = (int)((double)x2 + nx * (double)cut2);
        endPoint[3] = (int)((double)y2 + ny * (double)cut2);
        return endPoint;
    }

    private int[] getArcHead(float x1, float y1, float x2, float y2) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        double dist = Math.sqrt(dx * dx + dy * dy);
        float nx = (float)((double)dx / dist) * 20.0f;
        float ny = (float)((double)dy / dist) * 20.0f;
        double c1x = s_cosa1 * (double)nx - s_sina1 * (double)ny + (double)x2;
        double c1y = s_sina1 * (double)nx + s_cosa1 * (double)ny + (double)y2;
        double c2x = s_cosa2 * (double)nx - s_sina2 * (double)ny + (double)x2;
        double c2y = s_sina2 * (double)nx + s_cosa2 * (double)ny + (double)y2;
        int[] a = new int[]{(int)x2, (int)y2, (int)c1x, (int)c1y, (int)c2x, (int)c2y};
        return a;
    }

    public void updatePosition() {
        if (this.m_numPoints == 2) {
            int dx = this.m_source.getX() - this.m_target.getX();
            int dy = this.m_source.getY() - this.m_target.getY();
            this.m_x = this.m_source.getX() - dx / 2;
            this.m_y = this.m_source.getY() - dy / 2;
        } else {
            this.m_x = (int)this.m_pathData.points[2];
            this.m_y = (int)this.m_pathData.points[3];
        }
    }

    public void updateID() {
        this.m_id = String.valueOf(this.m_source.getID()) + " to " + this.m_target.getID();
    }

    @Override
    public String toXML() {
        String xml = "<arc id=\"" + this.m_id + "\" source=\"" + this.m_source.getID() + "\" target=\"" + this.m_target.getID() + "\">\n";
        xml = String.valueOf(xml) + "<inscription>\n<value>";
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES + 4) {
            xml = String.valueOf(xml) + new String(Component.s_tokenIDs[i]) + "," + this.m_arcWeights[i] + ",";
            ++i;
        }
        xml = xml.substring(0, xml.length() - 1);
        xml = String.valueOf(xml) + "</value>\n<offset x=\"" + this.m_label.getX() + "\" y=\"" + this.m_label.getY() + "\"/>" + "</inscription>\n";
        xml = String.valueOf(xml) + "<arcpath id=\"0\" x=\"" + (int)this.m_pathData.points[0] + "\" y=\"" + (int)this.m_pathData.points[1] + "\" curvePoint=\"false\"/>\n";
        if (this.m_numPoints > 2) {
            xml = String.valueOf(xml) + "<arcpath id=\"1\" x=\"" + (int)this.m_pathData.points[2] + "\" y=\"" + (int)this.m_pathData.points[3] + "\" curvePoint=\"true\"/>\n";
            xml = String.valueOf(xml) + "<arcpath id=\"2\" x=\"" + (int)this.m_pathData.points[6] + "\" y=\"" + (int)this.m_pathData.points[7] + "\" curvePoint=\"false\"/>\n";
        } else {
            xml = String.valueOf(xml) + "<arcpath id=\"1\" x=\"" + (int)this.m_pathData.points[2] + "\" y=\"" + (int)this.m_pathData.points[3] + "\" curvePoint=\"false\"/>\n";
        }
        xml = String.valueOf(xml) + "</arc>\n";
        return xml;
    }

    @Override
    public void removeTokenType(int type) {
        this.m_arcWeights[type] = 0;
        int weightsum = 0;
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES + 4) {
            weightsum += this.m_arcWeights[i];
            ++i;
        }
        if (weightsum == 0) {
            this.m_arcWeights[0] = 1;
        }
    }

    @Override
    public boolean openPropertiesDialog(Canvas canvas) {
        ArcPropertiesDialog dia = new ArcPropertiesDialog(canvas.getShell(), this, this.m_petrinet.getUniverse());
        return dia.open();
    }

    @Override
    public void delete(PetriNet pn) {
        this.m_isDeleted = true;
        if (!this.m_source.isDeleted()) {
            this.m_source.removeOutArc(this);
        }
        if (!this.m_target.isDeleted()) {
            this.m_target.removeInArc(this);
        }
    }

    public Arc copy(PetriNet net) {
        Arc a = net.constructArc(this.m_source.getID(), this.m_target.getID());
        if (a != null) {
            a.setArcWeights(this.m_arcWeights);
            if (this.m_numPoints > 2) {
                this.updatePosition();
                a.drag(this.m_x, this.m_y);
            }
            Label l = new Label(a);
            l.drag(this.m_label.getX() + 5, this.m_label.getY() + 10);
        }
        return a;
    }
}

