/*
 * Decompiled with CFR 0.152.
 */
package versys.dialogs;

import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import versys.petrinet.Component;
import versys.petrinet.PetriNet;

public class TokenColorDialog
extends Dialog {
    private Image[] m_images;
    private boolean[] m_universe;
    protected boolean[] m_result;
    protected Button[] m_chkButtons;
    protected Shell shlMarkenfarben;
    private Table table;
    private TableColumn tblclmnX;
    private TableColumn tblclmnFarbe;

    public TokenColorDialog(Shell parent, boolean[] universe) {
        super(parent, 2144);
        this.setText("Markenfarben");
        this.getParent().setEnabled(false);
        this.m_universe = (boolean[])universe.clone();
        this.m_chkButtons = new Button[PetriNet.TOKEN_NUM_TYPES];
        this.m_images = new Image[PetriNet.TOKEN_NUM_TYPES];
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            ImageData id = new ImageData(20, 20, 4, Component.s_paletteData);
            this.m_images[i] = new Image((Device)Display.getDefault(), id);
            GC gc = new GC((Drawable)this.m_images[i]);
            gc.setBackground(Component.s_tokenColors[i]);
            gc.fillRectangle(0, 0, 20, 20);
            gc.dispose();
            ++i;
        }
    }

    public boolean[] open() {
        this.createContents();
        this.shlMarkenfarben.open();
        this.shlMarkenfarben.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shlMarkenfarben.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            this.m_images[i].dispose();
            ++i;
        }
        return this.m_result;
    }

    private void createContents() {
        this.shlMarkenfarben = new Shell(this.getParent(), 2144);
        this.shlMarkenfarben.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TokenColorDialog.this.getParent().setEnabled(true);
            }
        });
        this.shlMarkenfarben.setSize(249, 200);
        this.shlMarkenfarben.setText("Markenfarben");
        this.shlMarkenfarben.setLayout(null);
        this.table = new Table((Composite)this.shlMarkenfarben, 2560);
        this.table.setBounds(10, 10, 223, 119);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tblclmnX = new TableColumn(this.table, 0x1000000);
        this.tblclmnX.setImage(SWTResourceManager.getImage(TokenColorDialog.class, "/assets/system-help-3.png"));
        this.tblclmnX.setWidth(50);
        this.tblclmnFarbe = new TableColumn(this.table, 0);
        this.tblclmnFarbe.setWidth(100);
        this.tblclmnFarbe.setText("Farbe");
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            TableItem item = new TableItem(this.table, 526336);
            item.setImage(1, this.m_images[i]);
            try {
                item.setText(1, Component.s_tokenIDs[i]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TableEditor editor = new TableEditor(this.table);
            this.m_chkButtons[i] = new Button((Composite)this.table, 32);
            this.m_chkButtons[i].setSelection(this.m_universe[i]);
            this.m_chkButtons[i].setBackground(SWTResourceManager.getColor(255, 255, 255));
            editor.grabHorizontal = true;
            editor.horizontalAlignment = 0x1000000;
            editor.setEditor((Control)this.m_chkButtons[i], item, 0);
            ++i;
        }
        this.tblclmnX.pack();
        this.m_chkButtons[0].setEnabled(false);
        Button btnAbbrechen = new Button((Composite)this.shlMarkenfarben, 0);
        btnAbbrechen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TokenColorDialog.this.m_result = null;
                TokenColorDialog.this.shlMarkenfarben.dispose();
            }
        });
        btnAbbrechen.setBounds(10, 135, 86, 27);
        btnAbbrechen.setText("Abbrechen");
        Button btnOk = new Button((Composite)this.shlMarkenfarben, 0);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TokenColorDialog.this.m_result = new boolean[PetriNet.TOKEN_NUM_TYPES];
                int i = 0;
                while (i < PetriNet.TOKEN_NUM_TYPES) {
                    if (TokenColorDialog.this.m_chkButtons[i] != null) {
                        TokenColorDialog.this.m_result[i] = TokenColorDialog.this.m_chkButtons[i].getSelection();
                    }
                    ++i;
                }
                TokenColorDialog.this.shlMarkenfarben.dispose();
            }
        });
        btnOk.setBounds(147, 135, 86, 27);
        btnOk.setText("OK");
    }
}

