/*
 * Decompiled with CFR 0.152.
 */
package versys.dialogs;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.wb.swt.SWTResourceManager;
import versys.petrinet.Arc;
import versys.petrinet.Component;
import versys.petrinet.PetriNet;

public class ArcPropertiesDialog
extends Dialog {
    protected boolean result;
    protected Shell shlKanteEigenschaften;
    private Arc m_arc;
    private boolean[] m_universe;
    private Spinner[] m_spinners;
    private CLabel helpLabel;
    private ToolTip tipVarLabels;
    private Button btnResetCurve;
    private Table tblConstWeights;
    private Table tblVarWeights;
    private Image[] m_images;

    public ArcPropertiesDialog(Shell parent, Arc a, boolean[] universe) {
        super(parent, 2144);
        this.getParent().setEnabled(false);
        this.m_arc = a;
        this.m_universe = (boolean[])universe.clone();
        this.m_spinners = new Spinner[PetriNet.TOKEN_NUM_TYPES + 4];
        this.m_images = new Image[PetriNet.TOKEN_NUM_TYPES];
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            ImageData id = new ImageData(20, 20, 4, Component.s_paletteData);
            this.m_images[i] = new Image((Device)Display.getDefault(), id);
            GC gc = new GC((Drawable)this.m_images[i]);
            gc.setBackground(Component.s_tokenColors[i]);
            gc.fillRectangle(0, 0, 20, 20);
            gc.dispose();
            ++i;
        }
    }

    public boolean open() {
        this.createContents();
        this.shlKanteEigenschaften.open();
        this.shlKanteEigenschaften.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shlKanteEigenschaften.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            this.m_images[i].dispose();
            ++i;
        }
        return this.result;
    }

    private void createContents() {
        this.shlKanteEigenschaften = new Shell(this.getParent(), this.getStyle());
        this.shlKanteEigenschaften.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ArcPropertiesDialog.this.getParent().setEnabled(true);
            }
        });
        this.shlKanteEigenschaften.setSize(394, 275);
        this.shlKanteEigenschaften.setText("Kante - Eigenschaften");
        Button btnOk = new Button((Composite)this.shlKanteEigenschaften, 0);
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] weights = new int[PetriNet.TOKEN_NUM_TYPES + 4];
                int i = 0;
                while (i < PetriNet.TOKEN_NUM_TYPES + 4) {
                    if (ArcPropertiesDialog.this.m_spinners[i] != null) {
                        weights[i] = ArcPropertiesDialog.this.m_spinners[i].getSelection();
                    }
                    ++i;
                }
                ArcPropertiesDialog.this.m_arc.setArcWeights(weights);
                if (ArcPropertiesDialog.this.btnResetCurve.getSelection()) {
                    ArcPropertiesDialog.this.m_arc.resetCurve();
                }
                ArcPropertiesDialog.this.result = true;
                ArcPropertiesDialog.this.shlKanteEigenschaften.dispose();
            }
        });
        btnOk.setBounds(292, 208, 86, 27);
        btnOk.setText("OK");
        Button btnAbbrechen = new Button((Composite)this.shlKanteEigenschaften, 0);
        btnAbbrechen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArcPropertiesDialog.this.result = false;
                ArcPropertiesDialog.this.shlKanteEigenschaften.dispose();
            }
        });
        btnAbbrechen.setBounds(10, 208, 86, 27);
        btnAbbrechen.setText("Abbrechen");
        this.btnResetCurve = new Button((Composite)this.shlKanteEigenschaften, 32);
        this.btnResetCurve.setBounds(10, 184, 336, 21);
        this.btnResetCurve.setText("Kurvenverlauf zur\u00fccksetzen");
        this.btnResetCurve.setSelection(false);
        this.btnResetCurve.setEnabled(this.m_arc.isCurved());
        Label lblKantengewichte = new Label((Composite)this.shlKanteEigenschaften, 0);
        lblKantengewichte.setFont(SWTResourceManager.getFont("Sans", 10, 0));
        lblKantengewichte.setBounds(9, 10, 178, 17);
        lblKantengewichte.setText("Kantengewichte:");
        Composite composite = new Composite((Composite)this.shlKanteEigenschaften, 2048);
        composite.setBounds(10, 33, 368, 145);
        Label lblKonstantesKantengewicht = new Label(composite, 0);
        lblKonstantesKantengewicht.setBounds(0, 0, 67, 17);
        lblKonstantesKantengewicht.setText("Konstant");
        this.tblConstWeights = new Table(composite, 67584);
        this.tblConstWeights.setBounds(0, 23, 190, 120);
        this.tblConstWeights.setHeaderVisible(true);
        this.tblConstWeights.setLinesVisible(true);
        TableColumn tblclmnColor = new TableColumn(this.tblConstWeights, 0);
        tblclmnColor.setWidth(86);
        tblclmnColor.setText("Farbe");
        TableColumn tblclmnColorAmount = new TableColumn(this.tblConstWeights, 0);
        tblclmnColorAmount.setWidth(85);
        tblclmnColorAmount.setText("Anzahl");
        int i = 0;
        while (i < PetriNet.TOKEN_NUM_TYPES) {
            if (this.m_universe[i]) {
                TableItem item = new TableItem(this.tblConstWeights, 0);
                item.setImage(0, this.m_images[i]);
                try {
                    item.setText(0, Component.s_tokenIDs[i]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TableEditor editor = new TableEditor(this.tblConstWeights);
                this.m_spinners[i] = new Spinner((Composite)this.tblConstWeights, 2048);
                this.m_spinners[i].setMaximum(9999);
                this.m_spinners[i].setSelection(this.m_arc.getArcWeights()[i]);
                editor.grabHorizontal = true;
                editor.setEditor((Control)this.m_spinners[i], item, 1);
            }
            ++i;
        }
        tblclmnColorAmount.pack();
        this.tblVarWeights = new Table(composite, 67584);
        this.tblVarWeights.setBounds(196, 23, 170, 120);
        this.tblVarWeights.setHeaderVisible(true);
        this.tblVarWeights.setLinesVisible(true);
        TableColumn tblclmnVar = new TableColumn(this.tblVarWeights, 0);
        tblclmnVar.setWidth(62);
        tblclmnVar.setText("Variable");
        TableColumn tblclmnVarFactor = new TableColumn(this.tblVarWeights, 0);
        tblclmnVarFactor.setWidth(100);
        tblclmnVarFactor.setText("Anzahl");
        Label lblVariablesKantengewicht = new Label(composite, 0);
        lblVariablesKantengewicht.setBounds(196, 0, 53, 17);
        lblVariablesKantengewicht.setText("Variabel");
        this.helpLabel = new CLabel(composite, 0);
        this.helpLabel.setBounds(255, 0, 22, 18);
        this.tipVarLabels = new ToolTip(this.helpLabel.getShell(), 4098);
        this.tipVarLabels.setText("Variables Kantengewicht");
        this.tipVarLabels.setMessage("Bei variablen Kantengewichten steht je eine Variable f\u00fcr\neine Markenfarbe. Eine Kante mit dem Gewicht 2X und 3Y \nk\u00f6nnte z.B. 2 schwarze und 3 rote Marken oder auch 5 blaueb \nMarken transportieren.\nHat eine Transition mehrere eingehende Kanten mit vari-\nablen Kantengewichten, dann steht z.B. eine Variable X\nan allen Kanten f\u00fcr dieselben Markenfarbe.");
        this.tipVarLabels.setAutoHide(false);
        this.helpLabel.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                ArcPropertiesDialog.this.tipVarLabels.setVisible(true);
            }

            public void mouseExit(MouseEvent e) {
                ArcPropertiesDialog.this.tipVarLabels.setVisible(false);
            }
        });
        this.helpLabel.setImage(SWTResourceManager.getImage(ArcPropertiesDialog.class, "/assets/system-help-3.png"));
        int i2 = PetriNet.TOKEN_NUM_TYPES;
        while (i2 < PetriNet.TOKEN_NUM_TYPES + 4) {
            TableItem item = new TableItem(this.tblVarWeights, 0);
            try {
                item.setText(0, Component.s_tokenIDs[i2]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TableEditor editor = new TableEditor(this.tblVarWeights);
            this.m_spinners[i2] = new Spinner((Composite)this.tblVarWeights, 2048);
            this.m_spinners[i2].setMaximum(9999);
            this.m_spinners[i2].setSelection(this.m_arc.getArcWeights()[i2]);
            editor.grabHorizontal = true;
            editor.setEditor((Control)this.m_spinners[i2], item, 1);
            ++i2;
        }
        tblclmnVarFactor.pack();
        i2 = 0;
        while (i2 < PetriNet.TOKEN_NUM_TYPES + 4) {
            if (this.m_spinners[i2] != null) {
                this.m_spinners[i2].addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int weightSum = 0;
                        int k = 0;
                        while (k < PetriNet.TOKEN_NUM_TYPES + 4) {
                            if (ArcPropertiesDialog.this.m_spinners[k] != null) {
                                weightSum += ArcPropertiesDialog.this.m_spinners[k].getSelection();
                            }
                            ++k;
                        }
                        if (weightSum == 0) {
                            ((Spinner)e.getSource()).setSelection(1);
                        }
                    }
                });
            }
            ++i2;
        }
    }
}

