/*
 * Decompiled with CFR 0.152.
 */
package versys;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import versys.petrinet.Arc;
import versys.petrinet.Component;
import versys.petrinet.Label;
import versys.petrinet.PetriNet;
import versys.petrinet.Place;
import versys.petrinet.Transition;

public class VersysFile {
    private final String m_xmlHeader = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    private final String m_xmlFooter = "</pnml>";
    private PetriNet m_petriNet;
    private String m_xml;
    private String m_path;

    public VersysFile(PetriNet pn) {
        this.m_petriNet = pn;
    }

    public VersysFile(String path) {
        this.m_path = path;
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            this.m_xml = "";
            String line = br.readLine();
            while (line != null) {
                this.m_xml = String.valueOf(this.m_xml) + line;
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getXML() throws UnsupportedEncodingException {
        String xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<pnml>\n";
        xml = String.valueOf(xml) + this.m_petriNet.toXML();
        xml = String.valueOf(xml) + "</pnml>";
        return xml;
    }

    public void parseSubNet(PetriNet petriNet, boolean selectSubNet) throws Exception {
        if (this.m_xml == null) {
            this.m_xml = this.getXML();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = factory.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(this.m_xml.getBytes("UTF-8"));
        Document doc = dBuilder.parse(is);
        boolean[] universe = petriNet.getUniverse();
        NodeList tokenTypes = doc.getElementsByTagName("token");
        int i = 0;
        while (i < tokenTypes.getLength()) {
            Element eTokenType = (Element)tokenTypes.item(i);
            String ttID = eTokenType.getAttribute("id");
            boolean ttEnabled = eTokenType.getAttribute("enabled").equals("true");
            int k = 0;
            while (k < PetriNet.TOKEN_NUM_TYPES) {
                if (new String(Component.s_tokenIDs[k]).equals(ttID)) {
                    universe[k] = universe[k] || ttEnabled;
                    break;
                }
                ++k;
            }
            ++i;
        }
        petriNet.setUniverse(universe);
        NodeList places = doc.getElementsByTagName("place");
        int i2 = 0;
        while (i2 < places.getLength()) {
            Element ePlace = (Element)places.item(i2);
            String pID = String.valueOf(ePlace.getAttribute("id")) + ".copy";
            Element ePos = (Element)ePlace.getElementsByTagName("graphics").item(0);
            Element eCoords = (Element)ePos.getElementsByTagName("position").item(0);
            int pX = Integer.parseInt(eCoords.getAttribute("x"));
            int pY = Integer.parseInt(eCoords.getAttribute("y"));
            Place p = new Place(pX, pY, pID);
            Element eName = (Element)ePlace.getElementsByTagName("name").item(0);
            boolean visible = !eName.getAttribute("visible").equals("false");
            Element eText = (Element)eName.getElementsByTagName("value").item(0);
            Label label = new Label(p);
            label.setText(eText.getTextContent());
            label.setVisible(visible);
            Element eOffset = (Element)eName.getElementsByTagName("graphics").item(0);
            eCoords = (Element)eOffset.getElementsByTagName("offset").item(0);
            int lX = Integer.parseInt(eCoords.getAttribute("x"));
            int lY = Integer.parseInt(eCoords.getAttribute("y"));
            label.drag(pX + lX + 5, pY + lY + 10);
            Element eInitial = (Element)ePlace.getElementsByTagName("initialMarking").item(0);
            eText = (Element)eInitial.getElementsByTagName("value").item(0);
            String tokenString = eText.getTextContent();
            StringTokenizer st = new StringTokenizer(tokenString, ",");
            int[] iniTokens = new int[PetriNet.TOKEN_NUM_TYPES];
            int currTokenType = 0;
            while (st.hasMoreTokens()) {
                st.nextToken();
                iniTokens[currTokenType] = Integer.parseInt(st.nextToken());
                ++currTokenType;
            }
            p.setTokens(iniTokens);
            petriNet.addComponent(p, selectSubNet);
            ++i2;
        }
        NodeList transitions = doc.getElementsByTagName("transition");
        int i3 = 0;
        while (i3 < transitions.getLength()) {
            Element eTransition = (Element)transitions.item(i3);
            String tID = String.valueOf(eTransition.getAttribute("id")) + ".copy";
            Element ePos = (Element)eTransition.getElementsByTagName("graphics").item(0);
            Element eCoords = (Element)ePos.getElementsByTagName("position").item(0);
            int tX = Integer.parseInt(eCoords.getAttribute("x"));
            int tY = Integer.parseInt(eCoords.getAttribute("y"));
            Transition t = new Transition(tX, tY, tID);
            Element eName = (Element)eTransition.getElementsByTagName("name").item(0);
            boolean visible = !eName.getAttribute("visible").equals("false");
            Element eText = (Element)eName.getElementsByTagName("value").item(0);
            Label label = new Label(t);
            label.setText(eText.getTextContent());
            label.setVisible(visible);
            Element eOffset = (Element)eName.getElementsByTagName("graphics").item(0);
            eCoords = (Element)eOffset.getElementsByTagName("offset").item(0);
            int lX = Integer.parseInt(eCoords.getAttribute("x"));
            int lY = Integer.parseInt(eCoords.getAttribute("y"));
            label.drag(tX + lX + 5, tY + lY + 10);
            petriNet.addComponent(t, selectSubNet);
            ++i3;
        }
        NodeList arcs = doc.getElementsByTagName("arc");
        int i4 = 0;
        while (i4 < arcs.getLength()) {
            Element eArc = (Element)arcs.item(i4);
            String aSource = String.valueOf(eArc.getAttribute("source")) + ".copy";
            String aTarget = String.valueOf(eArc.getAttribute("target")) + ".copy";
            Arc a = petriNet.constructArc(aSource, aTarget);
            Label label = new Label(a);
            Element eInscription = (Element)eArc.getElementsByTagName("inscription").item(0);
            Element eText = (Element)eInscription.getElementsByTagName("value").item(0);
            String tokenString = eText.getTextContent();
            StringTokenizer st = new StringTokenizer(tokenString, ",");
            int[] arcWeights = new int[PetriNet.TOKEN_NUM_TYPES + 4];
            int currTokenType = 0;
            while (st.hasMoreTokens() && currTokenType < arcWeights.length) {
                st.nextToken();
                arcWeights[currTokenType] = Integer.parseInt(st.nextToken());
                ++currTokenType;
            }
            a.setArcWeights(arcWeights);
            Element eOffset = (Element)eInscription.getElementsByTagName("offset").item(0);
            int lX = Integer.parseInt(eOffset.getAttribute("x"));
            int lY = Integer.parseInt(eOffset.getAttribute("y"));
            NodeList arcPath = eArc.getElementsByTagName("arcpath");
            if (arcPath.getLength() > 2) {
                Element eCurvePoint = (Element)arcPath.item(1);
                int cX = Integer.parseInt(eCurvePoint.getAttribute("x"));
                int cY = Integer.parseInt(eCurvePoint.getAttribute("y"));
                a.drag(cX, cY);
            }
            a.updatePosition();
            label.drag(lX + 5, lY + 10);
            petriNet.addComponent(a, selectSubNet);
            ++i4;
        }
        petriNet.serializeComponentIDs();
    }

    public PetriNet parsePetriNet() throws Exception {
        ByteArrayInputStream is;
        DocumentBuilderFactory factory;
        DocumentBuilder dBuilder;
        Document doc;
        NodeList nets;
        if (this.m_xml == null) {
            this.m_xml = this.getXML();
        }
        if ((nets = (doc = (dBuilder = (factory = DocumentBuilderFactory.newInstance()).newDocumentBuilder()).parse(is = new ByteArrayInputStream(this.m_xml.getBytes("UTF-8")))).getElementsByTagName("net")).getLength() > 1) {
            throw new Exception("Datei enth\u00e4lt mehrere Netze");
        }
        if (nets.getLength() < 1) {
            throw new Exception("Datei enth\u00e4lt kein Petrinetz.");
        }
        String netId = nets.item(0).getAttributes().getNamedItem("id").getNodeValue();
        PetriNet petriNet = new PetriNet(netId);
        this.parseSubNet(petriNet, false);
        return petriNet;
    }

    public void saveToXML(String path) {
        this.m_path = path;
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
            BufferedWriter bw = new BufferedWriter(osw);
            bw.write(this.getXML());
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFilePath() {
        return this.m_path;
    }
}

