/*
 * Decompiled with CFR 0.152.
 */
package versys;

import java.util.ArrayList;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.swt.SWTResourceManager;
import org.eclipse.wb.swt.layout.grouplayout.GroupLayout;
import versys.EditorTab;
import versys.Tool;
import versys.VersysFile;
import versys.dialogs.AboutDialog;
import versys.dialogs.ErrorDialog;
import versys.dialogs.NamingDialog;
import versys.dialogs.TokenColorDialog;
import versys.dialogs.UnsavedChangesDialog;
import versys.petrinet.PNState;
import versys.petrinet.PetriNet;

public class Versys {
    public static final short MajorVersion = 1;
    public static final short MinorVersion = 3;
    public static final short RevisionVersion = 4;
    public static final String ASSETS = "/assets/";
    protected static Versys s_versys;
    protected Shell m_shlVersys;
    protected Display m_display;
    private ToolBar m_toolBar;
    private ToolBar m_tokenBar;
    private ToolItem m_toolManualSim;
    private ToolItem m_toolAutoSim;
    private Spinner m_spinDelay;
    private Spinner m_spinAmount;
    private ProgressBar m_progressBar;
    private Tool m_lastTool = Tool.TOOLS_SELECT;
    private Tool m_currentTool = Tool.TOOLS_SELECT;
    private int m_currTokenType = 0;
    private TabFolder m_tabFolder;
    private ArrayList<EditorTab> m_editorTabs;
    private EditorTab m_currentTab;
    private PetriNet m_clipboard;

    public static void main(String[] args) {
        try {
            s_versys = new Versys();
            s_versys.open();
        }
        catch (SWTException swte) {
            swte.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.m_display = Display.getDefault();
        this.createContents();
        this.setMode(PNState.PN_STATE_UNDEF);
        this.m_shlVersys.open();
        this.m_shlVersys.layout();
        while (!this.m_shlVersys.isDisposed()) {
            if (this.m_display.readAndDispatch()) continue;
            this.m_display.sleep();
        }
    }

    protected void createContents() {
        this.m_shlVersys = new Shell();
        this.m_shlVersys.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                int numTabs = Versys.this.m_editorTabs.size();
                int i = 0;
                while (i < numTabs) {
                    Versys.this.m_tabFolder.setSelection(0);
                    Versys.this.m_currentTab = (EditorTab)Versys.this.m_editorTabs.get(0);
                    if (!Versys.this.closeCurrentTab()) {
                        e.doit = false;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.m_shlVersys.setImage(SWTResourceManager.getImage(Versys.class, "/assets/versys-icon.png"));
        this.m_shlVersys.setMinimumSize(new Point(700, 300));
        this.m_shlVersys.setBackground(SWTResourceManager.getColor(19));
        this.m_shlVersys.setSize(700, 480);
        this.m_shlVersys.setText("Versys");
        this.m_display.addFilter(1, new Listener(){

            public void handleEvent(Event e) {
                if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 118) {
                    Versys.this.translateClipboard();
                    Versys.this.pasteClipboard();
                }
            }
        });
        Menu menu = new Menu((Decorations)this.m_shlVersys, 2);
        this.m_shlVersys.setMenuBar(menu);
        MenuItem mntmDatei = new MenuItem(menu, 64);
        mntmDatei.setText("Datei");
        Menu menu_datei = new Menu(mntmDatei);
        mntmDatei.setMenu(menu_datei);
        MenuItem mntmNeu = new MenuItem(menu_datei, 0);
        mntmNeu.setImage(SWTResourceManager.getImage(Versys.class, "/assets/document-new-6.png"));
        mntmNeu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamingDialog newDialog = new NamingDialog(Versys.this.m_shlVersys, EditorTab.getDefaultName());
                String name = newDialog.open();
                if (name != "") {
                    Versys.this.m_currentTab = new EditorTab(s_versys, Versys.this.m_tabFolder, name);
                    Versys.this.m_editorTabs.add(Versys.this.m_currentTab);
                    Versys.this.m_tabFolder.setSelection(Versys.this.m_editorTabs.size() - 1);
                    Versys.this.setMode(PNState.PN_STATE_EDIT);
                }
            }
        });
        mntmNeu.setText("Neu ...\tStrg N");
        mntmNeu.setAccelerator(262254);
        MenuItem mntmffnen = new MenuItem(menu_datei, 0);
        mntmffnen.setImage(SWTResourceManager.getImage(Versys.class, "/assets/document-open-7.png"));
        mntmffnen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog openDialog = new FileDialog(Versys.this.m_shlVersys, 4096);
                openDialog.setFilterExtensions(new String[]{"*.xml"});
                String path = openDialog.open();
                if (path != null) {
                    EditorTab newTab = null;
                    try {
                        VersysFile vf = new VersysFile(path);
                        newTab = new EditorTab(s_versys, Versys.this.m_tabFolder, vf);
                    }
                    catch (Exception ex) {
                        new ErrorDialog(Versys.this.m_shlVersys, "Datei konnte nicht ge\u00f6ffnet werden.", ex).open();
                    }
                    if (newTab != null) {
                        System.out.println("newTab (open) != null");
                        Versys.this.m_currentTab = newTab;
                        Versys.this.m_editorTabs.add(Versys.this.m_currentTab);
                        Versys.this.m_tabFolder.setSelection(Versys.this.m_editorTabs.size() - 1);
                        Versys.this.setMode(Versys.this.m_currentTab.getState());
                    }
                }
            }
        });
        mntmffnen.setText("\u00d6ffnen...\tStrg O");
        mntmffnen.setAccelerator(262255);
        new MenuItem(menu_datei, 2);
        MenuItem mntmSpeichern = new MenuItem(menu_datei, 0);
        mntmSpeichern.setImage(SWTResourceManager.getImage(Versys.class, "/assets/document-save-5.png"));
        mntmSpeichern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_tabFolder.getSelectionIndex() == -1) {
                    return;
                }
                String path = Versys.this.m_currentTab.getFilePath();
                if (path == null) {
                    FileDialog saveDialog = new FileDialog(Versys.this.m_shlVersys, 8192);
                    saveDialog.setFilterExtensions(new String[]{"*.xml"});
                    saveDialog.setFileName(Versys.this.m_currentTab.getName());
                    path = saveDialog.open();
                }
                if (path != null) {
                    Versys.this.m_currentTab.save(path);
                }
            }
        });
        mntmSpeichern.setText("Speichern...\tStrg S");
        mntmSpeichern.setAccelerator(262259);
        MenuItem mntmSpeichernUnter = new MenuItem(menu_datei, 0);
        mntmSpeichernUnter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_tabFolder.getSelectionIndex() == -1) {
                    return;
                }
                FileDialog saveDialog = new FileDialog(Versys.this.m_shlVersys, 8192);
                saveDialog.setFilterExtensions(new String[]{"*.xml"});
                saveDialog.setFileName(Versys.this.m_currentTab.getName());
                String path = saveDialog.open();
                if (path != null) {
                    Versys.this.m_currentTab.save(path);
                }
            }
        });
        mntmSpeichernUnter.setText("Speichern unter...\tStrg+Umsch S");
        mntmSpeichernUnter.setAccelerator(393331);
        MenuItem mntmBildSpeichern = new MenuItem(menu_datei, 0);
        mntmBildSpeichern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_tabFolder.getSelectionIndex() == -1) {
                    return;
                }
                FileDialog saveDialog = new FileDialog(Versys.this.m_shlVersys, 8192);
                saveDialog.setFilterExtensions(new String[]{"*.png"});
                saveDialog.setFileName(String.valueOf(Versys.this.m_currentTab.getName()) + " (Bild)");
                Versys.this.m_currentTab.saveImage(saveDialog.open());
            }
        });
        mntmBildSpeichern.setText("Bild exportieren...");
        new MenuItem(menu_datei, 2);
        MenuItem mntmSchlieen = new MenuItem(menu_datei, 0);
        mntmSchlieen.setImage(SWTResourceManager.getImage(Versys.class, "/assets/document-close-4.png"));
        mntmSchlieen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Versys.this.closeCurrentTab();
            }
        });
        mntmSchlieen.setText("Schlie\u00dfen\tStrg W");
        mntmSchlieen.setAccelerator(262263);
        MenuItem mntmBeenden = new MenuItem(menu_datei, 0);
        mntmBeenden.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Versys.this.m_shlVersys.close();
            }
        });
        mntmBeenden.setText("Beenden");
        MenuItem mntmBearbeiten = new MenuItem(menu, 64);
        mntmBearbeiten.setText("Bearbeiten");
        Menu menu_bearbeiten = new Menu(mntmBearbeiten);
        mntmBearbeiten.setMenu(menu_bearbeiten);
        MenuItem mntmRckgngig = new MenuItem(menu_bearbeiten, 0);
        mntmRckgngig.setImage(SWTResourceManager.getImage(Versys.class, "/assets/edit-undo-5.png"));
        mntmRckgngig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_currentTab != null) {
                    Versys.this.m_currentTab.undo();
                }
            }
        });
        mntmRckgngig.setText("R\u00fcckg\u00e4ngig\tStrg Z");
        mntmRckgngig.setAccelerator(262266);
        MenuItem mntmWiederholen = new MenuItem(menu_bearbeiten, 0);
        mntmWiederholen.setImage(SWTResourceManager.getImage(Versys.class, "/assets/edit-redo-5.png"));
        mntmWiederholen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_currentTab != null) {
                    Versys.this.m_currentTab.redo();
                }
            }
        });
        mntmWiederholen.setText("Wiederholen\tStrg Y");
        mntmWiederholen.setAccelerator(262265);
        MenuItem menuItem_1 = new MenuItem(menu_bearbeiten, 2);
        menuItem_1.setText("");
        MenuItem mntmAusschneiden = new MenuItem(menu_bearbeiten, 0);
        mntmAusschneiden.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_currentTab != null) {
                    Versys.this.cutSelectionToClipboard();
                }
            }
        });
        mntmAusschneiden.setImage(SWTResourceManager.getImage(Versys.class, "/assets/edit-cut-6.png"));
        mntmAusschneiden.setText("Ausschneiden\tStrg X");
        mntmAusschneiden.setAccelerator(262264);
        MenuItem mntmKopieren_1 = new MenuItem(menu_bearbeiten, 0);
        mntmKopieren_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_currentTab != null) {
                    Versys.this.copySelectionToClipboard();
                }
            }
        });
        mntmKopieren_1.setImage(SWTResourceManager.getImage(Versys.class, "/assets/edit-copy-6.png"));
        mntmKopieren_1.setText("Kopieren\tStrg C");
        mntmKopieren_1.setAccelerator(262243);
        MenuItem mntmEinfgen = new MenuItem(menu_bearbeiten, 0);
        mntmEinfgen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_currentTab != null) {
                    Versys.this.pasteClipboard();
                }
            }
        });
        mntmEinfgen.setImage(SWTResourceManager.getImage(Versys.class, "/assets/edit-paste-6.png"));
        mntmEinfgen.setText("Einf\u00fcgen\tStrg V");
        MenuItem menuItem = new MenuItem(menu_bearbeiten, 2);
        menuItem.setText("Sep");
        MenuItem mntmNetzKopieren = new MenuItem(menu_bearbeiten, 0);
        mntmNetzKopieren.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_currentTab != null) {
                    Versys.this.copyCurrentNet();
                }
            }
        });
        mntmNetzKopieren.setText("Netz Kopieren");
        MenuItem mntmNetzUmbenennen = new MenuItem(menu_bearbeiten, 0);
        mntmNetzUmbenennen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_currentTab != null) {
                    Versys.this.renameCurrentNet();
                }
            }
        });
        mntmNetzUmbenennen.setText("Netz Umbenennen");
        MenuItem mntmAnsichat = new MenuItem(menu, 64);
        mntmAnsichat.setText("Ansicht");
        Menu menu_ansicht = new Menu(mntmAnsichat);
        mntmAnsichat.setMenu(menu_ansicht);
        MenuItem mntmVergrern = new MenuItem(menu_ansicht, 0);
        mntmVergrern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (Versys.this.m_currentTab != null) {
                    Versys.this.m_currentTab.zoomIn();
                }
            }
        });
        mntmVergrern.setText("Vergr\u00f6\u00dfern\tStrg +");
        mntmVergrern.setAccelerator(262187);
        MenuItem mntmVerkleinern = new MenuItem(menu_ansicht, 0);
        mntmVerkleinern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (Versys.this.m_currentTab != null) {
                    Versys.this.m_currentTab.zoomOut();
                }
            }
        });
        mntmVerkleinern.setText("Verkleinern\tStrg -");
        mntmVerkleinern.setAccelerator(262189);
        MenuItem mntmNormalansicht = new MenuItem(menu_ansicht, 0);
        mntmNormalansicht.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (Versys.this.m_currentTab != null) {
                    Versys.this.m_currentTab.resetZoom();
                }
            }
        });
        mntmNormalansicht.setText("Normalansicht\tStrg 0");
        mntmNormalansicht.setAccelerator(262192);
        MenuItem mntmHilfe = new MenuItem(menu, 64);
        mntmHilfe.setText("Hilfe");
        Menu menu_hilfe = new Menu(mntmHilfe);
        mntmHilfe.setMenu(menu_hilfe);
        MenuItem mntmber = new MenuItem(menu_hilfe, 0);
        mntmber.setImage(SWTResourceManager.getImage(Versys.class, "/assets/rating.png"));
        mntmber.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new AboutDialog(Versys.this.m_shlVersys).open();
            }
        });
        mntmber.setText("\u00dcber...");
        this.m_toolBar = new ToolBar((Composite)this.m_shlVersys, 0x820000);
        ToolItem toolSelect = new ToolItem(this.m_toolBar, 16);
        toolSelect.setToolTipText("Auswahl");
        toolSelect.setImage(SWTResourceManager.getImage(Versys.class, "/assets/edit-select.png"));
        toolSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Versys.this.switchTool(Tool.TOOLS_SELECT);
            }
        });
        toolSelect.setSelection(true);
        ToolItem toolDelete = new ToolItem(this.m_toolBar, 16);
        toolDelete.setToolTipText("L\u00f6schen");
        toolDelete.setImage(SWTResourceManager.getImage(Versys.class, "/assets/edit-delete-6.png"));
        toolDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Versys.this.switchTool(Tool.TOOL_DELETE);
            }
        });
        ToolItem toolPlace = new ToolItem(this.m_toolBar, 16);
        toolPlace.setToolTipText("Platz");
        toolPlace.setImage(SWTResourceManager.getImage(Versys.class, "/assets/icon_place.png"));
        toolPlace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Versys.this.switchTool(Tool.TOOLS_PLACE);
            }
        });
        ToolItem toolTrans = new ToolItem(this.m_toolBar, 16);
        toolTrans.setToolTipText("Transition");
        toolTrans.setImage(SWTResourceManager.getImage(Versys.class, "/assets/icon_trans.png"));
        toolTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Versys.this.switchTool(Tool.TOOLS_TRANS);
            }
        });
        ToolItem toolArc = new ToolItem(this.m_toolBar, 16);
        toolArc.setImage(SWTResourceManager.getImage(Versys.class, "/assets/icon_arc.png"));
        toolArc.setToolTipText("Kante");
        toolArc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Versys.this.switchTool(Tool.TOOLS_ARCS);
            }
        });
        Label sep1 = new Label((Composite)this.m_shlVersys, 514);
        this.m_tokenBar = new ToolBar((Composite)this.m_shlVersys, 0x820000);
        ToolItem tltmC = new ToolItem(this.m_tokenBar, 0);
        tltmC.setToolTipText("Markenfarben");
        tltmC.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TokenColorDialog colorDialog = new TokenColorDialog(Versys.this.m_shlVersys, Versys.this.m_currentTab.getPetriNet().getUniverse());
                boolean[] universe = colorDialog.open();
                if (universe != null) {
                    Versys.this.m_currentTab.getPetriNet().setUniverse(universe);
                }
            }
        });
        tltmC.setImage(SWTResourceManager.getImage(Versys.class, "/assets/applications-graphics-4.png"));
        ToolBar simBar = new ToolBar((Composite)this.m_shlVersys, 0x820000);
        this.m_toolManualSim = new ToolItem(simBar, 32);
        this.m_toolManualSim.setToolTipText("manuelle Simulation");
        this.m_toolManualSim.setImage(SWTResourceManager.getImage(Versys.class, "/assets/arrow-right-3.png"));
        this.m_toolManualSim.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_toolManualSim.getSelection()) {
                    if (Versys.this.m_currentTab.getState() != PNState.PN_STATE_AUTO_SIM) {
                        Versys.this.m_currentTab.startManualSimulation();
                        Versys.this.m_lastTool = Versys.this.m_currentTool;
                    } else {
                        Versys.this.m_currentTab.stopAutoSimulation();
                        Versys.this.m_toolAutoSim.setSelection(false);
                        Versys.this.m_progressBar.setSelection(0);
                    }
                } else {
                    Versys.this.m_currentTab.stopSimulation();
                    Versys.this.m_progressBar.setSelection(0);
                    Versys.this.m_currentTool = Versys.this.m_lastTool;
                }
                Versys.this.setMode(Versys.this.m_currentTab.getState());
                Versys.this.m_currentTab.redraw();
            }
        });
        this.m_toolAutoSim = new ToolItem(simBar, 32);
        this.m_toolAutoSim.setToolTipText("automatische Simulation");
        this.m_toolAutoSim.setImage(SWTResourceManager.getImage(Versys.class, "/assets/arrow-right-double-3.png"));
        this.m_toolAutoSim.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (Versys.this.m_toolAutoSim.getSelection()) {
                    if (Versys.this.m_currentTab.getState() != PNState.PN_STATE_MANUAL_SIM) {
                        Versys.this.m_lastTool = Versys.this.m_currentTool;
                    }
                    Versys.this.m_currentTool = Tool.TOOLS_AUTO_SIM;
                    Versys.this.m_currentTab.startAutoSimulation(s_versys, Versys.this.m_spinAmount.getSelection(), Versys.this.m_spinDelay.getSelection());
                } else {
                    Versys.this.m_currentTab.stopSimulation();
                    Versys.this.m_progressBar.setSelection(0);
                    Versys.this.m_currentTool = Versys.this.m_lastTool;
                }
                Versys.this.setMode(Versys.this.m_currentTab.getState());
                Versys.this.m_currentTab.redraw();
            }
        });
        Label labelNum = new Label((Composite)this.m_shlVersys, 0);
        labelNum.setText("#:");
        this.m_spinAmount = new Spinner((Composite)this.m_shlVersys, 2048);
        this.m_spinAmount.setMaximum(9999);
        this.m_spinAmount.setMinimum(1);
        this.m_spinAmount.setSelection(100);
        Label lblMs = new Label((Composite)this.m_shlVersys, 0);
        lblMs.setText("ms:");
        this.m_spinDelay = new Spinner((Composite)this.m_shlVersys, 2048);
        this.m_spinDelay.setMaximum(9999);
        this.m_spinDelay.setMinimum(10);
        this.m_spinDelay.setSelection(100);
        this.m_progressBar = new ProgressBar((Composite)this.m_shlVersys, 0);
        this.m_tabFolder = new TabFolder((Composite)this.m_shlVersys, 0);
        this.m_tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index;
                PNState lastState = PNState.PN_STATE_UNDEF;
                if (Versys.this.m_currentTab != null) {
                    lastState = Versys.this.m_currentTab.getState();
                }
                if ((index = Versys.this.m_tabFolder.getSelectionIndex()) >= 0 && index < Versys.this.m_editorTabs.size()) {
                    Versys.this.m_currentTab = (EditorTab)Versys.this.m_editorTabs.get(Versys.this.m_tabFolder.getSelectionIndex());
                    if (Versys.this.m_currentTab.getState() != PNState.PN_STATE_AUTO_SIM) {
                        Versys.this.m_progressBar.setSelection(0);
                    }
                }
                if (Versys.this.m_currentTab != null) {
                    if (lastState == PNState.PN_STATE_EDIT) {
                        Versys.this.m_lastTool = Versys.this.m_currentTool;
                    }
                    Versys.this.setMode(Versys.this.m_currentTab.getState());
                } else {
                    Versys.this.setMode(PNState.PN_STATE_UNDEF);
                }
            }
        });
        this.m_editorTabs = new ArrayList();
        this.m_currentTab = null;
        Menu menu_3 = new Menu((Control)this.m_tabFolder);
        this.m_tabFolder.setMenu(menu_3);
        MenuItem mntmUmbenennen = new MenuItem(menu_3, 0);
        mntmUmbenennen.setImage(SWTResourceManager.getImage(Versys.class, "/assets/fontforge.png"));
        mntmUmbenennen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Versys.this.renameCurrentNet();
            }
        });
        mntmUmbenennen.setText("Netz Umbenennen");
        MenuItem mntmKopieren = new MenuItem(menu_3, 0);
        mntmKopieren.setImage(SWTResourceManager.getImage(Versys.class, "/assets/edit-copy-6.png"));
        mntmKopieren.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Versys.this.copyCurrentNet();
            }
        });
        mntmKopieren.setText("Netz Kopieren");
        MenuItem mntmSchlieen_1 = new MenuItem(menu_3, 0);
        mntmSchlieen_1.setImage(SWTResourceManager.getImage(Versys.class, "/assets/document-close-4.png"));
        mntmSchlieen_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Versys.this.closeCurrentTab();
            }
        });
        mntmSchlieen_1.setText("Schlie\u00dfen");
        GroupLayout gl_shlVersys = new GroupLayout((Composite)this.m_shlVersys);
        gl_shlVersys.setHorizontalGroup(gl_shlVersys.createParallelGroup(1).add(gl_shlVersys.createSequentialGroup().addContainerGap().add(gl_shlVersys.createParallelGroup(1).add((Control)this.m_tabFolder, -1, 672, Short.MAX_VALUE).add(gl_shlVersys.createSequentialGroup().add((Control)this.m_toolBar, -2, -1, -2).addPreferredGap(0).add((Control)sep1, -2, 10, -2).addPreferredGap(0).add((Control)this.m_tokenBar, -2, -1, -2).addPreferredGap(0, 158, Short.MAX_VALUE).add((Control)simBar, -2, -1, -2).addPreferredGap(0).add((Control)labelNum).addPreferredGap(0).add((Control)this.m_spinAmount, -2, 62, -2).addPreferredGap(0).add((Control)lblMs).addPreferredGap(0).add((Control)this.m_spinDelay, -2, 60, -2).addPreferredGap(0).add((Control)this.m_progressBar, -2, 93, -2))).addContainerGap()));
        gl_shlVersys.setVerticalGroup(gl_shlVersys.createParallelGroup(1).add(gl_shlVersys.createSequentialGroup().add(gl_shlVersys.createParallelGroup(1, false).add(gl_shlVersys.createSequentialGroup().add(12).add(gl_shlVersys.createParallelGroup(1, false).add((Control)this.m_toolBar, -2, -1, -2).add((Control)simBar, -2, -1, -2).add((Control)labelNum).add((Control)this.m_spinAmount, -2, -1, -2).add((Control)lblMs).add((Control)this.m_spinDelay, -2, -1, -2).add((Control)this.m_progressBar, -1, -1, Short.MAX_VALUE))).add(gl_shlVersys.createSequentialGroup().addContainerGap().add(gl_shlVersys.createParallelGroup(1).add((Control)this.m_tokenBar, -2, -1, -2).add((Control)sep1, -2, 27, -2)))).addPreferredGap(0).add((Control)this.m_tabFolder, -1, 392, Short.MAX_VALUE).addContainerGap()));
        this.m_shlVersys.setLayout((Layout)gl_shlVersys);
    }

    protected boolean closeCurrentTab() {
        int index;
        if (this.m_tabFolder.getSelectionIndex() == -1) {
            return false;
        }
        boolean close = false;
        if (this.m_currentTab.isChanged()) {
            UnsavedChangesDialog uscDialog = new UnsavedChangesDialog(this.m_shlVersys, this.m_currentTab);
            close = uscDialog.open();
            if (close) {
                this.m_editorTabs.remove(this.m_currentTab);
                this.m_currentTab.dispose();
            }
        } else {
            this.m_editorTabs.remove(this.m_currentTab);
            this.m_currentTab.dispose();
            close = true;
        }
        if ((index = this.m_tabFolder.getSelectionIndex()) == -1) {
            this.setMode(PNState.PN_STATE_UNDEF);
        } else {
            this.m_currentTab = this.m_editorTabs.get(index);
        }
        return close;
    }

    protected void setMode(PNState state) {
        switch (state) {
            case PN_STATE_EDIT: {
                this.m_toolBar.setEnabled(true);
                this.m_tokenBar.setEnabled(true);
                this.m_toolManualSim.setEnabled(true);
                this.m_toolManualSim.setSelection(false);
                this.m_toolAutoSim.setEnabled(true);
                this.m_toolAutoSim.setSelection(false);
                this.m_spinAmount.setEnabled(true);
                this.m_spinDelay.setEnabled(true);
                if (this.m_currentTool != Tool.TOOLS_MANUAL_SIM && this.m_currentTool != Tool.TOOLS_AUTO_SIM) break;
                this.m_currentTool = this.m_lastTool;
                break;
            }
            case PN_STATE_MANUAL_SIM: {
                this.m_toolBar.setEnabled(false);
                this.m_tokenBar.setEnabled(false);
                this.m_toolManualSim.setSelection(true);
                this.m_toolAutoSim.setSelection(false);
                this.m_currentTool = Tool.TOOLS_MANUAL_SIM;
                break;
            }
            case PN_STATE_AUTO_SIM: {
                this.m_toolBar.setEnabled(false);
                this.m_tokenBar.setEnabled(false);
                this.m_toolManualSim.setSelection(false);
                this.m_toolAutoSim.setSelection(true);
                this.m_currentTool = Tool.TOOLS_AUTO_SIM;
                break;
            }
            default: {
                this.m_toolBar.setEnabled(false);
                this.m_tokenBar.setEnabled(false);
                this.m_toolManualSim.setEnabled(false);
                this.m_toolAutoSim.setEnabled(false);
                this.m_spinAmount.setEnabled(false);
                this.m_spinDelay.setEnabled(false);
                this.m_currentTab = null;
            }
        }
    }

    public Tool getCurrentTool() {
        return this.m_currentTool;
    }

    public int getCurrentTokenType() {
        return this.m_currTokenType;
    }

    public void updateProgressBar(int id, int value, int max) {
        if (id == this.m_currentTab.getID()) {
            this.m_progressBar.setMaximum(max);
            this.m_progressBar.setSelection(value);
        }
    }

    private void renameCurrentNet() {
        NamingDialog nameDialog = new NamingDialog(this.m_shlVersys, this.m_currentTab.getName());
        String newName = nameDialog.open();
        if (!newName.equals("")) {
            this.m_currentTab.setName(newName);
        }
    }

    private void copyCurrentNet() {
        PetriNet net = this.m_currentTab.getPetriNet();
        NamingDialog nd = new NamingDialog(this.m_shlVersys, String.valueOf(net.getID()) + " (Kopie)");
        String name = nd.open();
        if (!name.equals("")) {
            EditorTab newTab = null;
            try {
                VersysFile vf = new VersysFile(this.m_currentTab.getPetriNet());
                newTab = new EditorTab(s_versys, this.m_tabFolder, vf, name);
            }
            catch (Exception ex) {
                new ErrorDialog(this.m_shlVersys, "Es ist ein Fehler aufgetreten.", ex).open();
            }
            if (newTab != null) {
                this.m_currentTab = newTab;
                this.m_editorTabs.add(this.m_currentTab);
                this.m_tabFolder.setSelection(this.m_editorTabs.size() - 1);
            }
        }
    }

    private void switchTool(Tool tool) {
        this.m_currentTool = tool;
        this.m_currentTab.resetOperations();
        this.m_currentTab.redraw();
    }

    private void cutSelectionToClipboard() {
        if (this.m_currentTab.getPetriNet().hasSelected()) {
            this.m_clipboard = this.m_currentTab.getPetriNet().copySelected();
            this.m_currentTab.backupNet();
            this.m_currentTab.getPetriNet().deleteSelected();
            this.m_currentTab.netChanged();
            this.m_currentTab.redraw();
        }
    }

    private void copySelectionToClipboard() {
        if (this.m_currentTab.getPetriNet().hasSelected()) {
            this.m_clipboard = this.m_currentTab.getPetriNet().copySelected();
        }
    }

    private void translateClipboard() {
        if (this.m_clipboard == null || this.m_currentTab.getState() != PNState.PN_STATE_EDIT) {
            return;
        }
        Point mp = this.m_currentTab.getMousePos();
        System.out.println("Mousepos: " + mp);
        Point c = this.m_clipboard.getCenter();
        System.out.println("Center: " + c);
        this.m_clipboard.translate(mp.x - c.x, mp.y - c.y);
    }

    private void pasteClipboard() {
        if (this.m_clipboard == null || this.m_currentTab.getState() != PNState.PN_STATE_EDIT) {
            return;
        }
        this.m_currentTab.getPetriNet().unselect();
        this.m_currentTab.backupNet();
        try {
            this.m_currentTab.getPetriNet().addSubNet(this.m_clipboard);
        }
        catch (Exception e) {
            new ErrorDialog(this.m_shlVersys, "Ein Fehler ist aufgetreten.", e).open();
        }
        this.m_currentTab.netChanged();
        this.m_currentTab.redraw();
    }
}

