/*
 * Decompiled with CFR 0.152.
 */
package versys;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.swt.SWTResourceManager;
import versys.AutoSimulation;
import versys.RunLog;
import versys.Tool;
import versys.Versys;
import versys.VersysFile;
import versys.dialogs.ErrorDialog;
import versys.petrinet.Arc;
import versys.petrinet.CType;
import versys.petrinet.Component;
import versys.petrinet.Label;
import versys.petrinet.Node;
import versys.petrinet.PNState;
import versys.petrinet.PetriNet;
import versys.petrinet.Place;
import versys.petrinet.Transition;

public class EditorTab {
    public static final Font CANVAS_FONT = SWTResourceManager.getFont("Monospaced", 10, 0);
    private static int s_numTabs = 1;
    private int m_id;
    private Versys m_versys;
    private Canvas m_canvas;
    private RunLog m_runLog;
    private int m_logWidth;
    private SashForm m_sashForm;
    private Composite m_composite;
    private TabItem m_tab;
    private PetriNet m_lastNet;
    private PetriNet m_currentNet;
    private Stack<PetriNet> m_undoStack;
    private Stack<PetriNet> m_redoStack;
    private Rectangle m_selectionRect;
    private Component m_arcStart;
    private boolean m_shiftDown;
    private boolean m_leftMousedown;
    private boolean m_rightMouseDown;
    private Point m_selectionOrig;
    private Point m_mousePos;
    private Point m_scrollReference;
    private Point m_scrollTotal;
    private Component m_dragReference;
    private boolean m_dragged;
    private double m_zoomFactor = 1.0;
    private String m_filePath;
    private boolean m_changed;

    public EditorTab(Versys versys, TabFolder parent, String id) {
        this.m_tab = new TabItem(parent, 0);
        this.m_tab.setText(id);
        this.m_versys = versys;
        this.m_currentNet = new PetriNet(id);
        this.m_composite = new Composite((Composite)this.m_tab.getParent(), 0);
        this.m_composite.setLayout((Layout)new FillLayout());
        this.m_sashForm = new SashForm(this.m_composite, 256);
        this.m_canvas = new Canvas((Composite)this.m_sashForm, 0x20040000);
        this.m_tab.setControl((Control)this.m_composite);
        this.init();
    }

    public EditorTab(Versys versys, TabFolder parent, VersysFile vFile) throws Exception {
        this.m_versys = versys;
        this.m_tab = new TabItem(parent, 0);
        try {
            this.m_currentNet = vFile.parsePetriNet();
        }
        catch (Exception e) {
            this.dispose();
            throw e;
        }
        this.m_filePath = vFile.getFilePath();
        this.m_tab.setText(this.m_currentNet.getID());
        this.m_composite = new Composite((Composite)this.m_tab.getParent(), 0);
        this.m_composite.setLayout((Layout)new FillLayout());
        this.m_sashForm = new SashForm(this.m_composite, 256);
        this.m_canvas = new Canvas((Composite)this.m_sashForm, 0x20040000);
        this.m_tab.setControl((Control)this.m_composite);
        this.init();
    }

    public EditorTab(Versys versys, TabFolder parent, VersysFile vFile, String id) throws Exception {
        this.m_versys = versys;
        this.m_tab = new TabItem(parent, 0);
        try {
            this.m_currentNet = vFile.parsePetriNet();
        }
        catch (Exception e) {
            this.dispose();
            throw e;
        }
        this.m_filePath = vFile.getFilePath();
        this.m_currentNet.setID(id);
        this.m_tab.setText(id);
        this.m_composite = new Composite((Composite)this.m_tab.getParent(), 0);
        this.m_composite.setLayout((Layout)new FillLayout());
        this.m_sashForm = new SashForm(this.m_composite, 256);
        this.m_canvas = new Canvas((Composite)this.m_sashForm, 0x20040000);
        this.m_tab.setControl((Control)this.m_composite);
        this.init();
    }

    private void init() {
        this.m_logWidth = 130;
        this.m_id = s_numTabs++;
        this.m_leftMousedown = false;
        this.m_mousePos = new Point(0, 0);
        this.m_selectionRect = new Rectangle(0, 0, 0, 0);
        this.m_undoStack = new Stack();
        this.m_redoStack = new Stack();
        this.m_tab.setText("*" + this.m_tab.getText());
        this.m_changed = true;
        this.m_canvas.setFont(CANVAS_FONT);
        this.m_sashForm.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (EditorTab.this.m_runLog == null || EditorTab.this.m_runLog.isDisposed()) {
                    return;
                }
                int width = ((EditorTab)EditorTab.this).m_tab.getParent().getBounds().width;
                EditorTab.this.m_sashForm.setWeights(new int[]{width - EditorTab.this.m_logWidth, EditorTab.this.m_logWidth + 1});
                EditorTab.this.m_sashForm.layout();
            }
        });
        this.m_canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                ((EditorTab)EditorTab.this).m_mousePos.x = (int)((double)e.x * EditorTab.this.m_zoomFactor);
                ((EditorTab)EditorTab.this).m_mousePos.y = (int)((double)e.y * EditorTab.this.m_zoomFactor);
                if (EditorTab.this.m_leftMousedown && EditorTab.this.m_versys.getCurrentTool() == Tool.TOOLS_SELECT) {
                    if (EditorTab.this.m_currentNet.hasSelected() && EditorTab.this.m_dragReference != null) {
                        EditorTab.this.m_currentNet.dragSelected(((EditorTab)EditorTab.this).m_mousePos.x, ((EditorTab)EditorTab.this).m_mousePos.y, EditorTab.this.m_dragReference);
                        EditorTab.this.m_dragged = true;
                    } else {
                        if (!EditorTab.this.m_shiftDown) {
                            EditorTab.this.m_currentNet.unselect();
                        }
                        EditorTab.this.m_currentNet.selectComponents(EditorTab.this.updateSelectionRect());
                    }
                    EditorTab.this.m_canvas.redraw();
                }
                if (EditorTab.this.m_arcStart != null) {
                    EditorTab.this.m_canvas.redraw();
                }
                if (EditorTab.this.m_rightMouseDown) {
                    int translateX = ((EditorTab)EditorTab.this).m_mousePos.x - ((EditorTab)EditorTab.this).m_scrollReference.x;
                    int translateY = ((EditorTab)EditorTab.this).m_mousePos.y - ((EditorTab)EditorTab.this).m_scrollReference.y;
                    ((EditorTab)EditorTab.this).m_scrollTotal.x += translateX;
                    ((EditorTab)EditorTab.this).m_scrollTotal.y += translateY;
                    EditorTab.this.m_scrollReference = new Point(((EditorTab)EditorTab.this).m_mousePos.x, ((EditorTab)EditorTab.this).m_mousePos.y);
                    EditorTab.this.m_currentNet.translate(translateX, translateY);
                    EditorTab.this.m_canvas.redraw();
                }
            }
        });
        this.m_canvas.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                switch (e.keyCode) {
                    case 131072: {
                        EditorTab.this.m_shiftDown = false;
                        break;
                    }
                }
            }

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 131072: {
                        EditorTab.this.m_shiftDown = true;
                        break;
                    }
                    case 27: {
                        EditorTab.this.m_arcStart = null;
                        EditorTab.this.m_canvas.redraw();
                        break;
                    }
                    case 127: {
                        EditorTab.this.backupNet();
                        if (!EditorTab.this.m_currentNet.deleteSelected()) break;
                        EditorTab.this.netChanged();
                        EditorTab.this.m_canvas.redraw();
                        break;
                    }
                }
            }
        });
        this.m_canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle viewRect = EditorTab.this.getViewRect();
                viewRect.x = 0;
                viewRect.y = 0;
                Image image = new Image((Device)e.display, viewRect);
                GC gc = new GC((Drawable)image);
                gc.setAntialias(1);
                gc.setBackground(SWTResourceManager.getColor(255, 255, 224));
                gc.fillRectangle(viewRect);
                if (EditorTab.this.m_arcStart != null && EditorTab.this.m_mousePos != null) {
                    gc.setAlpha(125);
                    gc.setForeground(SWTResourceManager.getColor(0, 0, 0));
                    gc.setLineWidth(2);
                    gc.drawLine(EditorTab.this.m_arcStart.getX(), EditorTab.this.m_arcStart.getY(), ((EditorTab)EditorTab.this).m_mousePos.x, ((EditorTab)EditorTab.this).m_mousePos.y);
                }
                gc.setAlpha(255);
                EditorTab.this.m_currentNet.draw(gc);
                if (!EditorTab.this.updateSelectionRect().isEmpty()) {
                    gc.setForeground(SWTResourceManager.getColor(0, 0, 0));
                    gc.setLineWidth(1);
                    if (EditorTab.this.m_zoomFactor > 1.0) {
                        gc.setLineWidth((int)EditorTab.this.m_zoomFactor);
                    }
                    gc.drawRectangle(EditorTab.this.m_selectionRect);
                }
                Rectangle clientArea = EditorTab.this.m_canvas.getBounds();
                e.gc.drawImage(image, 0, 0, viewRect.width, viewRect.height, 0, 0, clientArea.width, clientArea.height);
                gc.dispose();
                image.dispose();
            }
        });
        this.m_canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button != 1) {
                    EditorTab.this.resetOperations();
                }
                switch (e.button) {
                    case 1: {
                        EditorTab.this.leftMouseButtonDown(e);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        EditorTab.this.rightMouseButtonDown(e);
                        break;
                    }
                }
            }

            public void mouseUp(MouseEvent e) {
                switch (e.button) {
                    case 1: {
                        EditorTab.this.leftMouseButtonUp(e);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        EditorTab.this.rightMouseButtonUp(e);
                        break;
                    }
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                Tool currentTool = EditorTab.this.m_versys.getCurrentTool();
                if (currentTool == Tool.TOOLS_SELECT || currentTool == Tool.TOOLS_PLACE || currentTool == Tool.TOOLS_TRANS) {
                    EditorTab.this.resetOperations();
                    Component c = EditorTab.this.m_currentNet.checkSelect((int)((double)e.x * EditorTab.this.m_zoomFactor), (int)((double)e.y * EditorTab.this.m_zoomFactor));
                    if (c != null) {
                        EditorTab.this.m_leftMousedown = false;
                        EditorTab.this.backupNet();
                        if (c.openPropertiesDialog(EditorTab.this.m_canvas)) {
                            EditorTab.this.netChanged();
                        }
                    }
                }
            }
        });
    }

    public boolean canUndo() {
        return !this.m_rightMouseDown && this.m_undoStack.size() > 0 && this.getState() == PNState.PN_STATE_EDIT;
    }

    public boolean canRedo() {
        return !this.m_rightMouseDown && this.m_redoStack.size() > 0 && this.getState() == PNState.PN_STATE_EDIT;
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        this.m_redoStack.push(this.m_currentNet);
        this.m_currentNet = this.m_undoStack.pop();
        this.m_tab.setText("*" + this.m_currentNet.getID());
        this.m_canvas.redraw();
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        this.m_undoStack.push(this.m_currentNet);
        this.m_currentNet = this.m_redoStack.pop();
        this.m_tab.setText("*" + this.m_currentNet.getID());
        this.m_canvas.redraw();
    }

    private Rectangle updateSelectionRect() {
        this.m_selectionRect.x = 0;
        this.m_selectionRect.y = 0;
        this.m_selectionRect.width = 0;
        this.m_selectionRect.height = 0;
        if (this.m_selectionOrig == null) {
            return this.m_selectionRect;
        }
        if (this.m_selectionOrig.x < this.m_mousePos.x) {
            this.m_selectionRect.x = this.m_selectionOrig.x;
            this.m_selectionRect.width = this.m_mousePos.x - this.m_selectionOrig.x;
        } else {
            this.m_selectionRect.x = this.m_mousePos.x;
            this.m_selectionRect.width = this.m_selectionOrig.x - this.m_mousePos.x;
        }
        if (this.m_selectionOrig.y < this.m_mousePos.y) {
            this.m_selectionRect.y = this.m_selectionOrig.y;
            this.m_selectionRect.height = this.m_mousePos.y - this.m_selectionOrig.y;
        } else {
            this.m_selectionRect.y = this.m_mousePos.y;
            this.m_selectionRect.height = this.m_selectionOrig.y - this.m_mousePos.y;
        }
        return this.m_selectionRect;
    }

    public PetriNet getPetriNet() {
        return this.m_currentNet;
    }

    public void startManualSimulation() {
        this.m_runLog = new RunLog((Composite)this.m_sashForm, 0);
        this.m_runLog.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                EditorTab.this.m_logWidth = ((EditorTab)EditorTab.this).m_runLog.getBounds().width;
            }
        });
        int width = this.m_tab.getParent().getBounds().width;
        this.m_sashForm.setWeights(new int[]{width - this.m_logWidth, this.m_logWidth + 1});
        this.m_sashForm.layout();
        this.m_currentNet.startSimulation();
        this.m_canvas.redraw();
    }

    public void startAutoSimulation(Versys versys, int num, int delay) {
        if (this.m_currentNet.getState() != PNState.PN_STATE_MANUAL_SIM) {
            this.startManualSimulation();
        }
        AutoSimulation autoSim = new AutoSimulation(this.m_canvas, this.m_runLog, this.m_currentNet, num, delay, versys, this.getID());
        Thread tSim = new Thread(autoSim);
        this.m_currentNet.startAutoSimulation();
        this.m_canvas.redraw();
        tSim.start();
    }

    public void stopSimulation() {
        if (this.m_runLog != null) {
            this.m_runLog.dispose();
        }
        this.m_sashForm.layout();
        this.m_currentNet.stopSimulation();
        this.m_canvas.redraw();
    }

    public void stopAutoSimulation() {
        this.m_currentNet.stopAutoSimulation();
        this.m_canvas.redraw();
    }

    public void redraw() {
        this.m_canvas.redraw();
    }

    public void saveImage(String path) {
        if (path == null) {
            return;
        }
        Image image = new Image((Device)this.m_canvas.getDisplay(), this.m_canvas.getSize().x, this.m_canvas.getSize().y);
        GC gc = new GC((Drawable)this.m_canvas);
        gc.copyArea(image, 0, 0);
        ImageLoader imgLoader = new ImageLoader();
        imgLoader.data = new ImageData[]{image.getImageData()};
        imgLoader.save(path, 5);
        gc.dispose();
    }

    public void save(String path) {
        this.m_filePath = path;
        new VersysFile(this.m_currentNet).saveToXML(path);
        this.m_changed = false;
        this.m_tab.setText(this.m_currentNet.getID());
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public String getName() {
        return this.m_currentNet.getID();
    }

    public int getID() {
        return this.m_id;
    }

    public void setName(String name) {
        this.backupNet();
        this.m_currentNet.setID(name);
        this.m_tab.setText(name);
        this.netChanged();
    }

    public void dispose() {
        if (this.m_currentNet != null) {
            this.stopSimulation();
        }
        if (this.m_canvas != null) {
            this.m_canvas.dispose();
        }
        if (this.m_tab != null) {
            this.m_tab.dispose();
        }
    }

    public static String getDefaultName() {
        return new String("Petrinetz " + s_numTabs);
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public void backupNet() {
        try {
            this.m_lastNet = this.m_currentNet.copy();
        }
        catch (Exception e) {
            e.printStackTrace();
            new ErrorDialog(this.m_canvas.getShell(), "Ein Fehler ist aufgetreten.", e).open();
        }
    }

    public void netChanged() {
        if (!this.m_changed) {
            this.m_changed = true;
        }
        this.m_tab.setText("*" + this.m_currentNet.getID());
        this.m_undoStack.push(this.m_lastNet);
        this.m_redoStack.clear();
        this.m_canvas.redraw();
    }

    public void resetOperations() {
        this.m_currentNet.unselect();
        this.m_arcStart = null;
    }

    public PNState getState() {
        return this.m_currentNet.getState();
    }

    private void leftMouseButtonDown(MouseEvent e) {
        this.m_leftMousedown = true;
        Point pointer = new Point((int)((double)e.x * this.m_zoomFactor), (int)((double)e.y * this.m_zoomFactor));
        Component c = null;
        switch (this.m_versys.getCurrentTool()) {
            case TOOLS_SELECT: {
                this.backupNet();
                this.m_dragged = false;
                c = this.m_currentNet.checkSelect(pointer.x, pointer.y);
                if (this.m_currentNet.getSelected().size() > 1) {
                    if (c == null) {
                        if (!this.m_shiftDown) {
                            this.m_currentNet.unselect();
                        }
                        this.m_selectionOrig = new Point(pointer.x, pointer.y);
                        this.m_mousePos.x = pointer.x;
                        this.m_mousePos.y = pointer.y;
                        break;
                    }
                    if (this.m_shiftDown) {
                        this.m_currentNet.toggleSelection(c);
                        break;
                    }
                    if (!c.isSelected()) {
                        this.m_currentNet.unselect();
                        this.m_currentNet.toggleSelection(c);
                    }
                    this.m_dragReference = c;
                    break;
                }
                if (!this.m_shiftDown) {
                    this.m_currentNet.unselect();
                }
                if (c != null) {
                    this.m_currentNet.toggleSelection(c);
                    this.m_dragReference = c;
                    break;
                }
                this.m_selectionOrig = new Point(pointer.x, pointer.y);
                this.m_mousePos.x = pointer.x;
                this.m_mousePos.y = pointer.y;
                break;
            }
            case TOOL_DELETE: {
                this.m_currentNet.unselect();
                c = this.m_currentNet.checkSelect(pointer.x, pointer.y);
                if (c == null) break;
                this.backupNet();
                this.m_currentNet.deleteComponent(c);
                this.netChanged();
                break;
            }
            case TOOLS_PLACE: {
                c = this.m_currentNet.checkSelect(pointer.x, pointer.y);
                if (c != null) break;
                this.backupNet();
                Place p = new Place(pointer.x, pointer.y);
                new Label(p);
                this.m_currentNet.addComponent(p, false);
                this.netChanged();
                break;
            }
            case TOOLS_TRANS: {
                c = this.m_currentNet.checkSelect(pointer.x, pointer.y);
                if (c != null) break;
                this.backupNet();
                Transition t = new Transition(pointer.x, pointer.y);
                new Label(t);
                this.m_currentNet.addComponent(t, false);
                this.netChanged();
                break;
            }
            case TOOLS_ARCS: {
                c = this.m_currentNet.checkSelect(pointer.x, pointer.y);
                if (c == null) break;
                CType type = c.getType();
                if (this.m_arcStart != null) {
                    if ((this.m_arcStart.getType() != CType.CTYPE_PLACE || type != CType.CTYPE_TRANS) && (this.m_arcStart.getType() != CType.CTYPE_TRANS || type != CType.CTYPE_PLACE)) break;
                    this.backupNet();
                    Arc a = new Arc((Node)this.m_arcStart, (Node)c);
                    new Label(a);
                    this.m_currentNet.addComponent(a, false);
                    this.m_arcStart = null;
                    this.netChanged();
                    break;
                }
                if (type != CType.CTYPE_PLACE && type != CType.CTYPE_TRANS) break;
                this.m_arcStart = c;
                break;
            }
            case TOOLS_MANUAL_SIM: {
                c = this.m_currentNet.checkSelect(pointer.x, pointer.y);
                if (c == null || c.getType() != CType.CTYPE_TRANS || !((Transition)c).isEnabled()) break;
                try {
                    ((Transition)c).fire();
                    this.m_runLog.log(((Transition)c).getLabel().getText());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    new ErrorDialog(this.m_canvas.getShell(), ex.getMessage(), ex).open();
                }
                break;
            }
        }
        this.m_canvas.redraw();
    }

    private void leftMouseButtonUp(MouseEvent e) {
        this.m_leftMousedown = false;
        this.m_selectionOrig = null;
        if (this.m_dragged) {
            this.netChanged();
        } else if (this.m_dragReference != null && !this.m_shiftDown) {
            this.m_currentNet.unselect();
            this.m_currentNet.toggleSelection(this.m_dragReference);
        }
        this.m_dragReference = null;
        this.m_canvas.redraw();
    }

    private void rightMouseButtonDown(MouseEvent e) {
        this.m_rightMouseDown = true;
        this.m_scrollReference = new Point((int)((double)e.x * this.m_zoomFactor), (int)((double)e.y * this.m_zoomFactor));
        this.m_scrollTotal = new Point(0, 0);
    }

    private void rightMouseButtonUp(MouseEvent e) {
        this.m_rightMouseDown = false;
        this.translateUndoRedoStacks(this.m_scrollTotal.x, this.m_scrollTotal.y);
    }

    public void zoomIn() {
        System.out.println("Zoom in");
        if (this.m_zoomFactor > 0.4) {
            this.setZoomFactor(this.m_zoomFactor - 0.1);
        }
    }

    public Point getMousePos() {
        return this.m_mousePos;
    }

    public void zoomOut() {
        System.out.println("Zoom out");
        if (this.m_zoomFactor < 3.0) {
            this.setZoomFactor(this.m_zoomFactor + 0.1);
        }
    }

    public void resetZoom() {
        System.out.println("Resetting zoom");
        this.setZoomFactor(1.0);
    }

    public boolean contains(Point p) {
        Rectangle r = this.m_canvas.getBounds();
        return p.x >= 0 && p.x <= r.width && p.y >= 0 && p.y <= r.height;
    }

    private void setZoomFactor(double zoomFactor) {
        Rectangle currViewRect = this.getViewRect();
        this.m_zoomFactor = zoomFactor;
        Rectangle newViewRect = this.getViewRect();
        this.translateNets(currViewRect.x - newViewRect.x, currViewRect.y - newViewRect.y);
        this.m_canvas.redraw();
    }

    private void translateNets(int x, int y) {
        this.m_currentNet.translate(x, y);
        this.translateUndoRedoStacks(x, y);
    }

    private void translateUndoRedoStacks(int x, int y) {
        Iterator pnit = this.m_undoStack.iterator();
        while (pnit.hasNext()) {
            ((PetriNet)pnit.next()).translate(x, y);
        }
        pnit = this.m_redoStack.iterator();
        while (pnit.hasNext()) {
            ((PetriNet)pnit.next()).translate(x, y);
        }
    }

    private Rectangle getViewRect() {
        Rectangle canvasBounds = this.m_canvas.getBounds();
        double viewWidth = (double)canvasBounds.width * this.m_zoomFactor;
        double viewHeight = (double)canvasBounds.height * this.m_zoomFactor;
        double viewX = (double)canvasBounds.x + ((double)canvasBounds.width - viewWidth) / 2.0;
        double viewY = (double)canvasBounds.y + ((double)canvasBounds.height - viewHeight) / 2.0;
        return new Rectangle((int)viewX, (int)viewY, (int)viewWidth, (int)viewHeight);
    }
}

